package edu.mayo.bior.buildcatalog;

/**
 * The Build step to perform.  Note:  Order is important here as this is the sequence of steps that will be executed in this order
 */
public enum BuildStepKey
{
	/**
	 * Auto-resume from last failed step
	 */
	AUTO ("auto"),

	/**
    * Create a text file containing a JSON object as the last column.  This is the default first step
    */
   MAKE_JSON ("make_json"),

   /**
    * Create the catalog .tsv.bgz and tabix index from the text-json-file
    */
   MAKE_CATALOG ("make_catalog"),

   /**
    * Create the properties files, such as columns.tsv, datasource.properties, blacklist
    */
   MAKE_PROP_FILES ("make_prop_files"),

   /**
    * 3-way merge of properties files: default generated, manually edited (if resuming), previous catalog (if one is given)
    */
   MERGE_PROP_FILES ("merge_prop_files"),

   /**
    * Create H2 indexes of specific keys for bior_lookup
    */
   MAKE_INDEXES ("make_indexes"),

   /**
    * Verify syntax and some semantics of the catalog
    */
   VERIFY ("verify"),

   /**
    * Generate help documentation (text and markdown/html)
    */
   // put this back in when we implement this
   //HELP_DOCS ("docs"),

   /**
    * Generate a summary of the whole build process so far
    */
   // TODO - put this back in if we implement this
   // SUMMARY ("summary");
   ;

	
   private String mDisplayName;
   BuildStepKey(String displayName)
   {
      mDisplayName = displayName;
   }

   public String getDisplayName()
   {
      return mDisplayName;
   }

   public boolean isExecuteStep(BuildStepKey stepToStartFrom)
   {
      return this.compareTo(stepToStartFrom) >= 0;
   }
}
