package edu.mayo.bior.catalog.verification;

import org.junit.Test;

import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import static org.junit.Assert.assertTrue;

/**
 * Test CatalogOrderVerifier
 */
public class CatalogOrderVerifierTest
{
   @Test
   public void testChromosomeOrderPrintingBug498712() throws VerifierInputException
   {
      List<String> chrOrder = new ArrayList<String>();
      chrOrder.add("1");
      chrOrder.add("2");
      chrOrder.add("3");
      chrOrder.add("10");
      chrOrder.add("11");
      chrOrder.add("20");
      chrOrder.add("21");

      // no indexes for this test
      Map<String, String> indexNameToPathMap = new TreeMap<String, String>();

      File catalogFile = new File("src/test/resources/testData/verification/catalog_for_chr_order_bug_498712/catalog.tsv.bgz");

      StringWriter stringWriter = new StringWriter();
      MessageLogger messageLogger = new MessageLogger(stringWriter);

      CatalogOrderVerifier orderVerifier = new CatalogOrderVerifier(chrOrder, catalogFile.getPath(),
                                                                    indexNameToPathMap, messageLogger);
      orderVerifier.verify();
      assertTrue(stringWriter.toString().contains("Order of chromosomes: 1,2,3,10,11,20,21"));
   }

}
