package edu.mayo.bior.catalog.markdown.transformer.comparison;

import edu.mayo.bior.catalog.markdown.transformer.TransformException;
import org.junit.Test;

import java.io.IOException;

import static org.junit.Assert.assertEquals;

public class CatalogColumnChangesImplTest {

    private static final char NEWLINE = '\n';

    @Test
    public void transform() throws IOException, TransformException {

        final int PREVIOUS_CATALOG_ROWS = 5;
        final int REMOVED_ROWS = 2;
        final int ADDED_ROWS = 7;
        final int CURRENT_CATALOG_ROWS = PREVIOUS_CATALOG_ROWS - REMOVED_ROWS + ADDED_ROWS;

        CatalogDiffStatistics.ColumnStats unchangedCol = new CatalogDiffStatistics().new ColumnStats();
        unchangedCol.setName("UNCHANGED_COL");
        unchangedCol.setAdded(0);
        unchangedCol.setRemoved(0);
        unchangedCol.setValueChanged(0);
        unchangedCol.setDatatypeChanged(0);
        unchangedCol.setValueUnchanged(PREVIOUS_CATALOG_ROWS - REMOVED_ROWS);

        CatalogDiffStatistics.ColumnStats retiredCol = new CatalogDiffStatistics().new ColumnStats();
        retiredCol.setName("RETIRED_COL");
        retiredCol.setAdded(0);
        retiredCol.setRemoved(PREVIOUS_CATALOG_ROWS);
        retiredCol.setValueChanged(0);
        retiredCol.setDatatypeChanged(0);
        retiredCol.setValueUnchanged(0);

        CatalogDiffStatistics.ColumnStats newCol1 = new CatalogDiffStatistics().new ColumnStats();
        newCol1.setName("NEW_COL1");
        newCol1.setAdded(CURRENT_CATALOG_ROWS);
        newCol1.setRemoved(0);
        newCol1.setValueChanged(0);
        newCol1.setDatatypeChanged(0);
        newCol1.setValueUnchanged(0);

        CatalogDiffStatistics.ColumnStats newCol2 = new CatalogDiffStatistics().new ColumnStats();
        newCol2.setName("NEW_COL2");
        newCol2.setAdded(CURRENT_CATALOG_ROWS);
        newCol2.setRemoved(0);
        newCol2.setValueChanged(0);
        newCol2.setDatatypeChanged(0);
        newCol2.setValueUnchanged(0);

        CatalogDiffStatistics.SummaryStats summaryStats = new CatalogDiffStatistics().new SummaryStats();
        summaryStats.setCatalogOldEntries(PREVIOUS_CATALOG_ROWS);
        summaryStats.setCatalogNewEntries(CURRENT_CATALOG_ROWS);


        CatalogDiffStatistics stats = new CatalogDiffStatistics();
        CatalogDiffStatistics.ColumnStats[] columnStatsArr = {unchangedCol, retiredCol, newCol1, newCol2};
        stats.setColumnStats(columnStatsArr);
        stats.setSummaryStats(summaryStats);

        CatalogColumnChangesImpl transformer = new CatalogColumnChangesImpl(stats);

        final String ORIGINAL_MARKDOWN =
                "BEGIN" + NEWLINE +
                CatalogColumnChangesImpl.TEMPLATE_KEYWORD + NEWLINE +
                "END";

        final String EXPECTED_MARKDOWN =
                "BEGIN" + NEWLINE +
                "Metric | Description | Count" + NEWLINE +
                "--- | --- | ---" + NEWLINE +
                "Previous Columns | # of columns in the previous catalog | 2" + NEWLINE +
                "Removed Columns | # of columns removed from the previous catalog | -1" + NEWLINE +
                "Added Columns | # of columns added to the previous catalog | +2" + NEWLINE +
                "Current Columns | # of columns in the current catalog | 3" + NEWLINE +
                "Net Difference | Difference between Previous Columns and Current Columns | +1" + NEWLINE +
                "END";

        String actualMarkdown = transformer.transform(ORIGINAL_MARKDOWN);
        assertEquals(EXPECTED_MARKDOWN, actualMarkdown);
    }

    @Test
    public void transformMissingCatalogDiffStats() throws IOException, TransformException {

        CatalogColumnChangesImpl transformer = new CatalogColumnChangesImpl(null);

        final String ORIGINAL_MARKDOWN =
                "BEGIN" + NEWLINE +
                        CatalogColumnChangesImpl.TEMPLATE_KEYWORD + NEWLINE +
                        "END";

        final String EXPECTED_MARKDOWN =
                "BEGIN" + NEWLINE +
                        ComparisonStatsImpl.NOT_AVAILABLE_MESG + NEWLINE +
                        "END";

        String actualMarkdown = transformer.transform(ORIGINAL_MARKDOWN);
        assertEquals(EXPECTED_MARKDOWN, actualMarkdown);
    }
}
