package edu.mayo.bior.cli.cmd;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.IdentityPipe;
import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.bioinformatics.GFF32JSONPipe;
import edu.mayo.pipes.bioinformatics.genbank.Genbank2JSONPipe;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/**
 * Created by m102417 on 5/20/14.
 */
public class GBKs2JSONCommand implements CommandPlugin {
    private static final char OPTION_FEATURE = 'f';
    private static final char OPTION_FILE_TYPE = 't';
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private String operation;

    public void init(Properties props) throws Exception {
        operation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws Exception {

//        boolean keepJSON = false;
//        if (line.hasOption(OPTION_KEEP_JSON)) {
//            keepJSON = true;
//        }
//
        List<String> featureTypes = new ArrayList<String>();
        if (line.hasOption(OPTION_FEATURE)) {
            for (String value : line.getOptionValues(OPTION_FEATURE)) {
                featureTypes.add(value);
            }
        }
        String[] featureArr = featureTypes.toArray(new String[0]);
//
        String type = "DNA"; //
        if (line.hasOption(OPTION_FILE_TYPE)) {
            type = new String(line.getOptionValue(OPTION_FILE_TYPE));
        }
//


        Pipe preLogic  = new IdentityPipe();
        Pipe logic;
        if(featureTypes.size() > 0) {
            logic = new Genbank2JSONPipe(type, featureArr);
        }else {
            logic =  new Genbank2JSONPipe(type);
        }
        Pipe postLogic = new IdentityPipe();

        mPipeline.execute(preLogic, logic, postLogic);
    }

}
