package edu.mayo.bior.catalog.verification;

/** Error codes used by bior_verify_catalog.  Counts for these errors will be used in the summary info for verify. 
 * 		0: 		  INFO, WARNING, Non-error messages?  (or do we use NULL?)
 * 		1-99:  	  FATAL exceptions that kill that particular verify phase
 * 		100-199:  Metadata
 * 		200-299:  Tabix index problem; Lines returned from tabix don't match current line; mismatch _landmark vs col1, BioR Index problems; etc.
 * 		300-399:  Chrom order, names, ranges
 * 		400-499:  JSON syntax; data type/count mismatches between value and columns.tsv
 * 		500-599:  Reference matching issues
 * 		600-699:  Variant issues
 * 		700-x:    Other exceptions
 * @author m054457  Michael Meiners, 2018-06-03
 */
public class VerifyErrorCodes {
	//-------------------------------------------------------------------------------------------------------
	// FATAL EXCEPTIONS - (less than 100)
	//-------------------------------------------------------------------------------------------------------
	public static final int CATALOG_FILE_UNREADABLE 							= 1;
	public static final int CATALOG_FILE_UNREADABLE_NO_ROW_BY_ROW_VERIFICATION 	= 2;
	public static final int CATALOG_ROW_VERIFY_EXCEPTION 						= 3;
	public static final int CATALOG_GOLDEN_ATTRIBUTES_PARSE_ERROR 				= 4;

	//-------------------------------------------------------------------------------------------------------
	// Metadata errors
	//-------------------------------------------------------------------------------------------------------
	public static final int COLUMNS_TSV_READ_ERROR 											= 100;
	public static final int DATASOURCE_PROPERTIES_READ_ERROR 								= 101;
	public static final int COLUMNS_TSV_NO_FIELDS 											= 102;
	public static final int COLUMNS_TSV_HAS_ERRORS 											= 103;
	public static final int TABIX_INDEX_FILE_MISSING 										= 104;
	public static final int TABIX_INDEX_FILE_MISSING_SO_CANNOT_ENSURE_IS_NEWER_THAN_CATALOG = 105;
	public static final int TABIX_INDEX_FILE_TIMESTAMP_OLDER_THAN_CATALOG 					= 106;
	public static final int BIOR_KEY_INDEX_FILE_OLDER_THAN_CATALOG 							= 109;
	public static final int COLUMNS_TSV_BLACKLIST_FILE_MISSING_OR_UNREADABLE 				= 110;
	public static final int COLUMNS_TSV_BLACKLIST_FILE_READ_ERROR 							= 111;
	public static final int BAD_CATALOG_FORMAT_GENERAL 										= 112;
	public static final int BAD_CATALOG_FORMAT 												= 113;
	public static final int DATASOURCE_PROPERTIES_BAD_RELEASE_DATE                			= 114;

	//-------------------------------------------------------------------------------------------------------
	// Tabix and H2 index
	//-------------------------------------------------------------------------------------------------------
	public static final int TABIX_INDEX_FILE_MISSING_OR_CORRUPT 				= 200;
	public static final int CATALOG_COLUMN_COUNT_INCONSISTENT 					= 201;
	public static final int CATALOG_ORDER_EXCEPTION 							= 202;
	public static final int TABIX_ENTRY_MISSING 								= 203;
	public static final int BIOR_KEY_INDEX_VALUE_MISSING_ON_LAST_ROW_OF_CHROM 	= 204;
	public static final int BIOR_KEY_INDEX_VALUE_MISSING_ON_FIRST_ROW_OF_CHROM 	= 205;
	public static final int BIOR_KEY_INDEX_FILE_MISSING_OR_CORRUPT 				= 206;
	public static final int JSON_GOLDEN_ATTRIBUTE_MINBP_NOT_SPECIFIED 			= 207;
	public static final int JSON_GOLDEN_ATTRIBUTE_MAXBP_NOT_SPECIFIED 			= 208;
	public static final int TABIX_CHROMOSOME_DIFFERENT_FROM_LANDMARK 			= 209;
	public static final int TABIX_START_POSITION_DIFFERENT_FROM_MINBP 			= 210;
	public static final int TABIX_STOP_POSITION_DIFFERENT_FROM_MAXBP 			= 211;
	public static final int TABIX_STOP_POSITION_LESS_THAN_START 				= 212;
	public static final int MAXBP_LESS_THAN_MINBP 								= 213;
	public static final int TABIX_ENTRY_NOT_POSITIONAL_OR_NONPOSITIONAL 		= 214;
	public static final int TABIX_START_POSITION_NOT_IN_CHROMOSOME_RANGE 		= 215;
	public static final int TABIX_STOP_POSITION_NOT_IN_CHROMOSOME_RANGE			= 216;

	//-------------------------------------------------------------------------------------------------------
	// Chromosome order, size, name
	//-------------------------------------------------------------------------------------------------------
	public static final int CHROMOSOME_REPEATED_IN_NON_CONTIGUOUS_CHUNK = 300;
	public static final int CHROMOSOME_POSITIONS_OUT_OF_ORDER 			= 301;
	public static final int CHROMOSOME_NOT_IN_LIST 						= 302;
	public static final int CHROMOSOME_NOT_IN_INTEGER_RANGE 			= 303;
	public static final int CHROMOSOME_SHOULD_BE_INTEGER 				= 304;
	public static final int CHROMOSOME_MISSING 							= 305;
	public static final int CHROMOSOME_NOT_FOUND_IN_CHROM_SIZE_MAP		= 306;

	//-------------------------------------------------------------------------------------------------------
	// JSON parsing; data syntax, count, type mismatches
	//-------------------------------------------------------------------------------------------------------
	public static final int JSON_UNPARSEABLE 											= 400;
	public static final int JSON_KEYS_CANNOT_BE_VALIDATED_DUE_TO_MISSING_COLUMNS_TSV 	= 401;
	public static final int JSON_UNPARSEABLE_JSON_READER 								= 403;
	public static final int JSON_UNQUOTED_OR_BAD_QUOTES_IN_KEYS_OR_VALUES				= 404;
	public static final int JSON_KEY_NOT_FOUND_IN_COLUMNS_TSV							= 405;
	public static final int JSON_DATA_TYPE_MISMATCH										= 406;
	public static final int JSON_NO_DATATYPE_FOUND										= 407;
	public static final int JSON_KEY_MUST_NOT_CONTAIN_DOT								= 408;
	public static final int JSON_NO_JSON_VALUE_FOUND									= 409;
	public static final int JSON_PROBLEM_PARSING_JSON_PROPERTY							= 410;
	public static final int JSON_BAD_COLUMN_NAME_FORMAT_LESS_THAN_ONE_NAME				= 411;
	public static final int JSON_STRING_VALUE_NOT_QUOTED								= 412;
	public static final int JSON_NULL_VALUE												= 413;
	public static final int JSON_UNPARSEABLE_ROW_VERIFICATION 							= 414;
	public static final int JSON_DATA_COUNT_MISMATCH									= 415;
	public static final int JSON_PIPE_CHARACTER_FOUND_IN_JSON_ARRAY						= 420;
	

	
	//-------------------------------------------------------------------------------------------------------
	// Reference matching
	//-------------------------------------------------------------------------------------------------------
	public static final int REF_SEQUENCE_LOOKUP_FAILED 												= 500;
	public static final int JSON_GOLDEN_ATTRIBUTE_REF_ALLELE_DOES_NOT_MATCH_REF_SEQUENCE 			= 501;
	// If the golden attribute _refAllele does not match the ref sequence, but we are in Chromosome M, this is sometimes expected
	public static final int JSON_GOLDEN_ATTRIBUTE_REF_ALLELE_DOES_NOT_MATCH_REF_SEQUENCE_IN_CHROM_M = 502;
	public static final int REF_SEQUENCE_NOT_FOUND 													= 503;
	public static final int SUMMARY_SOME_REF_ALLELES_NOT_MATCHING_REF_SEQ 							= 504;
	public static final int SUMMARY_SOME_REF_ALLELES_NOT_MATCHING_REF_SEQ_CHROM_M 					= 505;

	//-------------------------------------------------------------------------------------------------------
	// Variant and reference sequence issues
	//-------------------------------------------------------------------------------------------------------
	public static final int JSON_GOLDEN_ATTRIBUTE_MISSING_REF_ALLELE 								= 600;
	public static final int JSON_GOLDEN_ATTRIBUTE_REF_ALLELE_LENGTH_NOT_SAME_AS_CALCULATED_LENGTH 	= 601;
	public static final int REF_ALLELE_CONTAINS_INVALID_NUCLEOTIDE 									= 602;
	public static final int JSON_GOLDEN_ATTRIBUTE_ALT_ALLELES_EMPTY 								= 603;
	public static final int ALT_ALLELE_CONTAINS_INVALID_NUCLEOTIDE 									= 604;
	public static final int JSON_GOLDEN_ATTRIBUTE_ALT_ALLELE_EQUALS_REF_ALLELE 						= 605;
	
}
