RELEASE=$1
GIT_TAG=$2

export TARGET=/research/bsi/tools/biotools/bior_scripts
export DATE=`date +%Y-%m-%d_%H-%M-%S`
export GIT_REPO=git@ssh.dev.azure.com:v3/mclm/GBS%20GSU/bior-toolkit
export TEMP_DIR=/research/bsi/development/wa01593/Temp/bior_toolkit_deploy_$DATE


function usage() {
  echo "USAGE:   $0  <RELEASE>  <GIT_TAG>"
  echo "Example: $0  5.1.0      bior-toolkit-5.1.0--2021-02-16"
  exit 1
}


if [ -z "$RELEASE" ]  ; then
  echo "RELEASE not specified"
  usage
  exit 1
fi

if [ -z "$GIT_TAG" ]  ; then
  echo "GIT_TAG not specified"
  usage
  exit 1
fi

set -exu

# Verify we are running under the user that owns the bior-toolkit files
OWNER=$(stat -c "%U" $TARGET)
if [ $USER != $OWNER ]; then
  echo "ERROR: The user running this script ($USER), must be the same as the owner of the target directory"
  echo "  Target dir: $TARGET"
  echo "  Owner:      $OWNER"
  exit 1
fi

# If the directory already exists, then prompt for overwrite
if [ -d $TARGET/$RELEASE ]; then
  read -p "Directory already exists.  Do you want to overwrite it? ('yes' to overwrite): " answer
  if [ "$answer" != 'yes' ]; then
    exit 1
  fi
fi
chmod u+w $TARGET
mkdir -p $TARGET/$RELEASE
chmod -R u+w $TARGET/$RELEASE


# Create a temp directory, clone the git repo, checkout the appropriate tag for the release, build the bior-toolkit and verify all tests run
mkdir -p $TEMP_DIR
cd $TEMP_DIR
git clone $GIT_REPO
cd bior-toolkit
git checkout $GIT_TAG
mvn clean verify
# mvn  clean package -DSkipTests  -X -U
# mvn clean package -DskipTests

# Eventually we'll have to get all further tests running:
# Run all the extra integration tests  -- NOTE: NEED TO ADD THIS IN LATER WHEN WE CAN GET THE BIOR_ANNOTATE.SH SCRIPTS PASSING
# cd scripts/DeploymentTests/
# ./runAllTests.sh

cp -r target/bior-toolkit-$RELEASE $TARGET/$RELEASE

# Set SAGE to production   (comment out the DEV settings; uncomment the PROD settings)
sed -i  's|^SAGE_|## SAGE_|g'                  $TARGET/$RELEASE/bior-toolkit-$RELEASE/conf/cli/Global.properties
sed -i  's|^# SAGE_SERVER=|## SAGE_SERVER=|g'  $TARGET/$RELEASE/bior-toolkit-$RELEASE/conf/cli/Global.properties
sed -i  's|^# SAGE_|SAGE_|g'                   $TARGET/$RELEASE/bior-toolkit-$RELEASE/conf/cli/Global.properties

#-----------------------------------------------
# mayobiotools updates
# Copy the PKG_PROFILE and update it with the RELEASE
cat $TARGET/.PKG_PROFILE_TEMPLATE | sed "s|VERSION|$RELEASE|g" > $TARGET/$RELEASE/PKG_PROFILE

# Update the current link to this version
cd $TARGET
rm current
ln -s $RELEASE current


#-----------------------------------------------
# Modules updates
MODULES_DIR=/usr/local/modules/Modules/bsi/bior_scripts
cd $MODULES_DIR
cat 5.0.0 | sed "s|5.0.0|$RELEASE|g" > $RELEASE

# Change the default link to the latest release
rm default
ln -s $RELEASE default

#-----------------------------------------------
# Setup BIOR_LITE_HOME and PATH
export $(grep "^BIOR_LITE_HOME=" $TARGET/$RELEASE/PKG_PROFILE)
export PATH=$BIOR_LITE_HOME/bin:$PATH

# Set permissions to read-execute only
chmod -R 555 $TARGET

#-----------------------------------------------
echo -e "\n\n======================="
echo "DONE."
echo "New toolkit published to: $TARGET/$RELEASE/bior-toolkit-$RELEASE"
echo "bior_drill version: $(which bior_drill)"

echo "Test drill: Should output: AAAA"
echo "{'key':'AAAA'}" | bior_drill -p key | grep -v "^#"

