package edu.mayo.bior.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * JUnbit tests for {@linkplain FilenameComparatorByNumericPart}
 *
 * <p>@author </p>
 */
public class FilenameComparatorByNumericPartTest {

	FilenameComparatorByNumericPart mFileCompare;
	
	/**
	 * Before each test create a new {@linkplain FilenameComparatorByNumericPart}
	 */
	@Before
	public void beforeEach() {
		mFileCompare = new FilenameComparatorByNumericPart();
	}
	
	/**
	 * Validate that sorting works as intended
	 */
	@Test
	public void testFileSort() {
		verifySort( toList("my.003.txt", "my.002.txt", "my.001.txt"),   toList("my.001.txt", "my.002.txt", "my.003.txt"));
		verifySort( toList("my.100.txt", "my.10.txt", "my.1.txt"),      toList("my.1.txt", "my.10.txt", "my.100.txt"));
		verifySort( toList("my.1.txt", "my.2.txt", "my.12.txt"),        toList("my.1.txt", "my.2.txt", "my.12.txt"));
		verifySort( toList("you.1.txt", "me.10.txt", "be.20.txt"),      toList("be.20.txt", "me.10.txt", "you.1.txt"));
		verifySort( toList("my.3.txt", "my.002.txt", "my.01.txt"),      toList("my.01.txt", "my.002.txt", "my.3.txt"));
		verifySort( toList("x", "x", "x"),      						toList("x", "x", "x"));
		verifySort( toList("aNum", "aNum123", "a"),    	 			    toList("a", "aNum", "aNum123"));
	
		verifySort( toList("my.03", "my.002"),   			toList("my.002", "my.03"));
		verifySort( toList("my.03", "my.020"),   			toList("my.03", "my.020"));
		verifySort( toList("my.12.txt", "my.120.txt"),   	toList("my.12.txt", "my.120.txt"));
		verifySort( toList("my.13.txt", "my.120.txt"),   	toList("my.13.txt", "my.120.txt"));
		verifySort( toList("my.4.txt", "my.1.txt"),       	toList("my.1.txt", "my.4.txt"));
		verifySort( toList("my.10000.txt", "my.47.txt"),   	toList("my.47.txt", "my.10000.txt"));
		verifySort( toList("my.30a.log", "my.3b.log"),     	toList("my.30a.log", "my.3b.log"));
		verifySort( toList("my.30a.log", "my.23b.log"),  	toList("my.23b.log", "my.30a.log"));
		verifySort( toList("my.40.txt", "you.1.vcf"),     	toList("my.40.txt",  "you.1.vcf"));
		verifySort( toList("my.19.txt", "my.100.txt"),     	toList("my.19.txt", "my.100.txt"));

		verifySort( toList("", "xyz"),     					toList("", "xyz"));
		verifySort( toList(null, "x"),     					toList(null, "x"));
	}
	
	private List<String> toList(String... strs) {
		List<String> list = new ArrayList<String>();
		for(String s : strs) {
			list.add(s);
		}
		return list;
	}

	private void verifySort(List<String> in,  List<String> expected)	{
		Collections.sort(in, mFileCompare);
		Assert.assertEquals(expected.toString(), in.toString());
	}
}
