package edu.mayo.bior.cli.func;

import static org.junit.Assert.assertEquals;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.Test;

import edu.mayo.pipes.util.test.PipeTestUtils;

public class RefAlleleCommandITCase extends BaseFunctionalTest
{
	@BeforeClass
	public static void beforeAll() throws FileNotFoundException {
		BaseFunctionalTest.setBiorToolkitCmdsRequired(true);
	}
	
	@Test
	public void refThatWrapsLine() throws IOException, InterruptedException
	{
        System.out.println("RefAlleleCommandITCase.refThatWrapsLine()");
        String stdin 	= "#CHROM\tMIN\tMAX\tJSON\n"
        				+ "22\t16050299\t16050306\t{\"_landmark\":\"22\",\"_minBP\":16050299,\"_maxBP\":16050306}\n"
        				+ "22\t16050300\t16050301\t{\"_landmark\":\"22\",\"_minBP\":16050300,\"_maxBP\":16050301}";
        String expected = "##BIOR=<ID=\"bior.refAllele.fasta\",Operation=\"bior_ref_allele\",DataType=\"JSON\",ShortUniqueName=\"refAllele.fasta\",Path=\"*/bior_pipeline/src/test/resources/refAllele.fasta.tsv.bgz\">\n"
        				+ "#CHROM\tMIN\tMAX\tJSON\tbior.refAllele.fasta\n"
        				+ "22\t16050299\t16050306\t{\"_landmark\":\"22\",\"_minBP\":16050299,\"_maxBP\":16050306}\tTGGATGAT\n"
        				+ "22\t16050300\t16050301\t{\"_landmark\":\"22\",\"_minBP\":16050300,\"_maxBP\":16050301}\tGG";
		
		CommandOutput out = executeScript("bior_ref_allele", stdin, "-d", "src/test/resources/refAllele.fasta.tsv.bgz", "-c", "-1");

		if( out.stderr != null && out.stderr.length() > 0 )
			System.out.println("STDERR:\n" + out.stderr + "\nSTDOUT:\n" + out.stdout);
		assertEquals("STDERR:" + out.stderr + "\n"+"STDOUT:" + out.stdout, 0, out.exit);
		assertEquals("", out.stderr);

		PipeTestUtils.assertListsEqual(Arrays.asList(expected.split("\n")), Arrays.asList(out.stdout.split("\n")), /*isIgnorePaths=*/ true, /*isExactStringMatch=*/false);
	}
	
}
