package edu.mayo.bior.catalog.markdown.transformer.comparison;

import edu.mayo.bior.catalog.markdown.transformer.TransformException;
import org.junit.Test;

import java.io.IOException;

import static org.junit.Assert.assertEquals;

public class CatalogRowUpdateImplTest {

    private static final char NEWLINE = '\n';

    @Test
    public void transform() throws IOException, TransformException {

        final int PREVIOUS_CATALOG_ROWS = 5;
        final int REMOVED_ROWS = 2;
        final int ADDED_ROWS = 7;
        final int VALUE_CHANGED_ROWS = 2;
        final int CURRENT_CATALOG_ROWS = PREVIOUS_CATALOG_ROWS - REMOVED_ROWS + ADDED_ROWS;

        CatalogDiffStatistics.SummaryStats summaryStats = new CatalogDiffStatistics().new SummaryStats();
        summaryStats.setCatalogOldEntries(PREVIOUS_CATALOG_ROWS);
        summaryStats.setCatalogEntriesAdded(ADDED_ROWS);
        summaryStats.setCatalogEntriesRemoved(REMOVED_ROWS);
        summaryStats.setCatalogNewEntries(CURRENT_CATALOG_ROWS);
        summaryStats.setCatalogEntriesChanged(ADDED_ROWS + REMOVED_ROWS + VALUE_CHANGED_ROWS);

        CatalogDiffStatistics stats = new CatalogDiffStatistics();
        stats.setSummaryStats(summaryStats);

        CatalogRowUpdateImpl transformer = new CatalogRowUpdateImpl(stats);

        final String ORIGINAL_MARKDOWN =
                "BEGIN" + NEWLINE +
                CatalogRowUpdateImpl.TEMPLATE_KEYWORD + NEWLINE +
                "END";

        final String EXPECTED_MARKDOWN =
                "BEGIN" + NEWLINE +
                "Metric | Description | Count | % of Intersection" + NEWLINE +
                "--- | --- | --- | ---" + NEWLINE +
                "Intersection Rows | # of rows present in both previous and current catalogs | 3 | 100.0%" + NEWLINE +
                "Unchanged Rows | intersection rows with no column changes | 1 | 33.3%" + NEWLINE +
                "Updated Rows | intersection rows that had at least 1 column change | 2 | 66.7%" + NEWLINE +
                "END";

        String actualMarkdown = transformer.transform(ORIGINAL_MARKDOWN);
        assertEquals(EXPECTED_MARKDOWN, actualMarkdown);
    }

    @Test
    public void transformMissingCatalogDiffStats() throws IOException, TransformException {

        CatalogRowUpdateImpl transformer = new CatalogRowUpdateImpl(null);

        final String ORIGINAL_MARKDOWN =
                "BEGIN" + NEWLINE +
                CatalogRowUpdateImpl.TEMPLATE_KEYWORD + NEWLINE +
                "END";

        final String EXPECTED_MARKDOWN =
                "BEGIN" + NEWLINE +
                ComparisonStatsImpl.NOT_AVAILABLE_MESG + NEWLINE +
                "END";

        String actualMarkdown = transformer.transform(ORIGINAL_MARKDOWN);
        assertEquals(EXPECTED_MARKDOWN, actualMarkdown);
    }
}
