package edu.mayo.bior.catalog.index;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;

import org.junit.Test;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;

import edu.mayo.pipes.util.test.PipeTestUtils;

public class IndexStatsTest {

	ByteArrayOutputStream mByteArrayOut = new ByteArrayOutputStream();
	PrintStream mTempStdoutWriter = new PrintStream(mByteArrayOut);
	PrintStream mOriginalStdoutWriter = System.out;
	
	@Test
	public void testSummary() throws IOException {
		String databasePath = new File("src/test/resources/index/genes.GeneID.idx.h2.db").getCanonicalPath();
		startStdoutCapture();
		new IndexStats().getStats(databasePath, 100);
		List<String> actual = stopStdoutCapture();
		//print(actual);
		List<String> expected = FileUtils.readLines(new File("src/test/resources/index/genes.GeneID.expected.summary.txt"));
		PipeTestUtils.assertListsEqual(expected, actual);
	}


	@Test
	public void testFullDump() throws IOException {
		String databasePath = new File("src/test/resources/testData/tabix/index/00-First1K_GRCh37.ID.idx.h2.db").getCanonicalPath();
		startStdoutCapture();
		new IndexStats().getStats(databasePath, -1);
		List<String> actual = stopStdoutCapture();
		//print(actual);
		List<String> expected = FileUtils.readLines(new File("src/test/resources/testData/tabix/index/00-First1K_GRCh37.ID.idx.h2.db.expected.full.txt"));
		PipeTestUtils.assertListsEqual(expected, actual);
	}


	private void startStdoutCapture() {
		mByteArrayOut.reset();
		System.setOut(mTempStdoutWriter);
	}

	private List<String> stopStdoutCapture() throws IOException {
		System.setOut(mOriginalStdoutWriter);
		mByteArrayOut.flush();
		return Arrays.asList(mByteArrayOut.toString().split("\n"));
	}

	private void print(List<String> actual) {
		for(String line : actual)
			System.out.println(line);
	}



}
