package edu.mayo.bior.catalog.fasta2ctg;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

import edu.mayo.pipes.util.test.PipeTestUtils;
import htsjdk.samtools.util.BlockCompressedInputStream;

public class FastaToCatalogTest {

	File tempDir;
	
	@Before
	public void beforeEach() throws IOException {
		TemporaryFolder temp = new TemporaryFolder();
		temp.create();
		tempDir = temp.newFolder();
	}
	

	@Test
	public void createCtg10PerLine() throws IOException, Exception {
		File fasta = new File("src/test/resources/testData/fastaToCtg/refAssembly.fa");
		File ctgOut = new File(tempDir, "refAssembly.tsv.bgz");
		new FastaToCatalog().fastaToCatalog(fasta.getCanonicalPath(), 10, ctgOut.getCanonicalPath());
		
		List<String> actual = readLines(ctgOut);
		List<String> expected = Arrays.asList(
				"1	1	10	TNNNNNNNNN",
				"1	11	20	NNNNNNNNNN",
				"1	21	30	NNNNNNNNNN",
				"1	31	40	NNNNNNNNNN",
				"1	41	50	NNNNNNNNNN",
				"1	51	60	TAACCCTAAC",
				"1	61	70	CCTAACCCTA",
				"1	71	80	ACCCTAACCC",
				"1	81	90	TAACCCTAAC",
				"1	91	100	CCTAACCCTG",
				"1	101	110	ACCCTAACCC",
				"1	111	120	TAACCCTAAC",
				"1	121	130	CCTAACCCTA",
				"1	131	140	ACCCTAACCC",
				"1	141	150	TAACCCTAAC",
				"1	151	160	CCTAACCCAA",
				"1	161	170	CCCTAACCCT",
				"1	171	180	AACCCTAACC",
				"1	181	190	CTAACCCTAA",
				"1	191	191	C",
				"2	1	10	GNNNNNNNNN",
				"2	11	20	NNNNNNNNNN",
				"2	21	30	NNNNNNNNNN",
				"2	31	40	NNNNNNNNNN",
				"2	41	50	NNNNNNNNNN",
				"2	51	60	CGTATCCCAC",
				"2	61	70	ACACCACACC",
				"2	71	80	CACACACCAC",
				"2	81	90	ACCCACACAC",
				"2	91	100	ACCCACACCC",
				"2	101	110	ACACCCACAC",
				"2	111	120	ACACCACACC",
				"2	121	130	CACACACCAC",
				"2	131	140	ACCCACACCC",
				"2	141	150	ACACACCACA",
				"2	151	160	CCCACACCAC",
				"2	161	170	ACCCACACAC",
				"2	171	180	CACACACCAC",
				"2	181	190	ACCCACACCC",
				"2	191	200	ACACACACCA",
				"2	201	210	CACCCACACA",
				"2	211	220	CCACACCCAC",
				"2	221	230	ACACACCCTA",
				"2	231	240	ACCCTAACCC",
				"2	241	250	CTAACCCCTA",
				"2	251	260	ACCCTAACCC",
				"2	261	270	TACCCGAACC",
				"2	271	280	CTAACCCTAA",
				"2	281	290	CCCTAACCCC",
				"2	291	300	TAACCCTAAC",
				"2	301	310	CCCTAACCCT",
				"2	311	320	AACCCTAACC",
				"2	321	330	GTAACCCTAA",
				"2	331	340	CCCTTTACCC",
				"2	341	350	TAACCCGAAC",
				"2	351	360	CCCTAACCCC",
				"2	361	370	TAACCCCTAA",
				"2	371	380	CCCTTAACCC",
				"2	381	390	TAACCCTTAA",
				"2	391	400	CCCTGACCCT"
				);
		PipeTestUtils.assertListsEqual(expected, actual);
	}

	@Test
	public void createCtg100PerLine() throws IOException, Exception {
		File fasta = new File("src/test/resources/testData/fastaToCtg/refAssembly.fa");
		File ctgOut = new File(tempDir, "refAssembly.tsv.bgz");
		new FastaToCatalog().fastaToCatalog(fasta.getCanonicalPath(), 100, ctgOut.getCanonicalPath());
		
		List<String> actual = readLines(ctgOut);
		List<String> expected = Arrays.asList(
				"1	1	100	TNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN"
						+  "TAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTG",	
				"1	101	191	ACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAAC"
						+  "CCTAACCCAACCCTAACCCTAACCCTAACCCTAACCCTAAC",
				"2	1	100	GNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN"
						+  "CGTATCCCACACACCACACCCACACACCACACCCACACACACCCACACCC",
				"2	101	200	ACACCCACACACACCACACCCACACACCACACCCACACCCACACACCACA"
						+  "CCCACACCACACCCACACACCACACACCACACCCACACCCACACACACCA",
				"2	201	300	CACCCACACACCACACCCACACACACCCTAACCCTAACCCCTAACCCCTA"
						+  "ACCCTAACCCTACCCGAACCCTAACCCTAACCCTAACCCCTAACCCTAAC",
				"2	301	400	CCCTAACCCTAACCCTAACCGTAACCCTAACCCTTTACCCTAACCCGAAC"
						+  "CCCTAACCCCTAACCCCTAACCCTTAACCCTAACCCTTAACCCTGACCCT"
				);
		PipeTestUtils.assertListsEqual(expected, actual);
	}


	@Test
	public void createCtg100000PerLine() throws IOException, Exception {
		File fasta = new File("src/test/resources/testData/fastaToCtg/refAssembly.fa");
		File ctgOut = new File(tempDir, "refAssembly.tsv.bgz");
		new FastaToCatalog().fastaToCatalog(fasta.getCanonicalPath(), 100000, ctgOut.getCanonicalPath());
		
		List<String> actual = readLines(ctgOut);
		List<String> expected = Arrays.asList(
				"1	1	191	TNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN"
				         + "TAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTG"
						 + "ACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAAC"
						 + "CCTAACCCAACCCTAACCCTAACCCTAACCCTAACCCTAAC",
				"2	1	400	GNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN"
						 + "CGTATCCCACACACCACACCCACACACCACACCCACACACACCCACACCC"
						 + "ACACCCACACACACCACACCCACACACCACACCCACACCCACACACCACA"
						 + "CCCACACCACACCCACACACCACACACCACACCCACACCCACACACACCA"
						 + "CACCCACACACCACACCCACACACACCCTAACCCTAACCCCTAACCCCTA"
						 + "ACCCTAACCCTACCCGAACCCTAACCCTAACCCTAACCCCTAACCCTAAC"
						 + "CCCTAACCCTAACCCTAACCGTAACCCTAACCCTTTACCCTAACCCGAAC"
						 + "CCCTAACCCCTAACCCCTAACCCTTAACCCTAACCCTTAACCCTGACCCT"
				);
		PipeTestUtils.assertListsEqual(expected, actual);
	}

	private List<String> readLines(File ctgOut) throws IOException {
		BufferedReader fin = new BufferedReader(new InputStreamReader(new BlockCompressedInputStream(ctgOut)));
		List<String> lines = new ArrayList<String>();
		String line = null;
		while( (line = fin.readLine()) != null ) {
			lines.add(line);
		}
		return lines;
	}
}
