package edu.mayo.bior.catalog;

import org.junit.Test;

import static junit.framework.Assert.assertEquals;
import static junit.framework.Assert.assertNull;

/**
 * Test out the HumanBuildAssembly methods.
 */
public class HumanBuildAssemblyTest
{
   @Test
   public void testBasic()
   {
      assertEquals(HumanBuildAssembly.NA,     HumanBuildAssembly.assemblyFromString(null));
      assertEquals(HumanBuildAssembly.NA,     HumanBuildAssembly.assemblyFromString("  mm10  "));
      assertEquals(HumanBuildAssembly.GRCh37, HumanBuildAssembly.assemblyFromString("  grch37.p13  "));
      assertEquals(HumanBuildAssembly.GRCh37, HumanBuildAssembly.assemblyFromString("GRCh37"));
      assertEquals(HumanBuildAssembly.GRCh38, HumanBuildAssembly.assemblyFromString("  grch38.p10  "));
      assertEquals(HumanBuildAssembly.GRCh38, HumanBuildAssembly.assemblyFromString("GRCh38"));
   }
}
