package edu.mayo.bior.util;

import java.io.File;
import java.io.IOException;

import edu.mayo.pipes.util.BiorProperties;
import edu.mayo.pipes.util.BiorProperties.Key;

/**
 * Created with IntelliJ IDEA.
 * User: m102417
 * Date: 8/21/13
 * Time: 1:41 PM
 * This class helps to check if a dependency is installed correctly
 */
public class DependancyUtil {

    /**
     * 
     * @param indexPath
     * @return	True or false
     */
    public static boolean isIndexInstalled(String indexPath){
        return isPathDepInstalled(indexPath,"BioR Index that is requested is not installed (either download it or run bior_index_catalog): ");
    }

    /**
     * 
     * @param catalogPath
     * @return	True or false
     */
    public static boolean isCatalogInstalled(String catalogPath){
        return isPathDepInstalled(catalogPath,"BioR Catalog that is requested is not installed: ");
    }

    /**
     * 
     * @param path
     * @param message
     * @return	True or false
     */
    public static boolean isPathDepInstalled(String path, String message){
        if(path == null){
            return false;
        }
        File f = new File(path);
        if(f.exists() == false){
            System.err.println(message + path);
            return false;
        }
        return true;
    }

    /**
     *
     * @param toolPath - this can be a full path, or a relative path
     * @return	True or false
     */
    public static boolean isToolInstalled(String toolPath){
        if(toolPath == null){
            return false;
        }
        File f = new File(toolPath);
        if(f.canExecute() == false){
            return false;
        }
        if(f.exists() == false){
            return false;
        }

        return true;
    }

    /**
     * check if snpEFF is installed correctly
     * @return	True or false
     * @throws IOException
     *
     * ###SNPEFF ============================================
        SnpEffJar=/research/bsi/tools/biotools/snpeff/3.5/snpEff.jar
        SnpEffConfig=/research/bsi/tools/biotools/snpeff/3.5/snpEff.config
     *
     */
    public static boolean isSNPEffInstalled() throws IOException{
        BiorProperties prop = new BiorProperties();
        
        String snpeffJarPath = prop.get(Key.SnpEffJar);
        File snpeffJarFile = new File(snpeffJarPath);
        if(snpeffJarFile == null || ! snpeffJarFile.exists()){
            System.err.println("SNPEffect is not correctly installed and on your path! you need to install it and modify the bior.properties file to use this feature!");
            System.err.println("Current Path: " + snpeffJarPath );
            System.err.println("bior.properties: " + BiorProperties.getFile());

            return false;
        }
        
        String snpeffConfigPath = prop.get(Key.SnpEffConfig);
        File snpeffConfigFile = new File(snpeffConfigPath);
        if(snpeffConfigFile == null || ! snpeffConfigFile.exists() ){
            System.err.println("SNPEffect config is not correctly installed and in the bior.properties file! You need to create a valid config file, please see the SNPEff documentation");
            System.err.println("Current Path: " + snpeffConfigPath );
            System.err.println("bior.properties: " + BiorProperties.getFile());
            return false;
        }
        
        return true;
    }
    
    /**
     *
     ###VEP ===============================================
     BiorVepPerl=/usr/local/biotools/perl/perl-5.26.2/bin/perl
     BiorVep=/usr/local/biotools/vep/vep-101/vep
     BiorVepCache=/research/bsi/data/refdata/app/vep/human/v101/cache/downloaded/2020_11_20/homo_sapiens/101_GRCh37
     * @return	True or false
     * @throws IOException 
     */
    public static boolean isVEPInstalled() throws IOException {
        BiorProperties prop = new BiorProperties();
        String veperl = prop.get("BioRVepPerl");
        if(isToolInstalled(veperl)){
            System.err.println("VEP needs perl 5.14.2 or greater, make sure it is installed and in the location specified in the bior.properties file");
            System.err.println("Current Path: " + veperl );
            System.err.println("bior.properties: " + BiorProperties.getFile());
            return false;
        }
        String vepcache = prop.get("BiorVepCache");
        File vepc = (vepcache == null) ? null : new File(vepcache);
        if( vepc == null || !vepc.exists() || !vepc.isDirectory()){
            System.err.println("VEP needs the cache to be downloaded, please read the VEP documentation to download the cache and specify the cache directory correctly in the bior.properties file");
            System.err.println("Current Path: " + vepcache );
            System.err.println("bior.properties: " + BiorProperties.getFile());
            return false;
        }
        String vep = prop.get("BiorVep");
        File vepf = new File(vep);
        if(vepf == null || !vepf.exists() ){
            System.err.println("VEP needs to be installed and in the location specified in your bior.properties file");
            System.err.println("Current Path: " + vep );
            System.err.println("bior.properties: " + BiorProperties.getFile());
            return false;
        }
        return true;
    }

}
