package edu.mayo.bior.catalog.markdown.transformer.comparison;

import edu.mayo.bior.catalog.markdown.transformer.MarkdownTransformer;
import edu.mayo.bior.catalog.markdown.transformer.TransformException;

import java.io.PrintWriter;
import java.io.StringWriter;

import static edu.mayo.bior.catalog.markdown.MarkdownUtils.chompTrailingNewlines;
import static edu.mayo.bior.catalog.markdown.transformer.comparison.ComparisonStatsImpl.NOT_AVAILABLE_MESG;
import static org.apache.commons.io.IOUtils.closeQuietly;

/**
 * Builds a markdown table about the previous/current catalogs.
 */
public class CatalogTableImpl implements MarkdownTransformer {

    static final String TEMPLATE_KEYWORD = "COMPARISON_STATISTICS_CATALOG_TABLE";

    private CatalogDiffStatistics stats;

    CatalogTableImpl(CatalogDiffStatistics stats) {
        this.stats = stats;
    }

    @Override
    public String transform(String markdown) throws TransformException {
        if (stats == null) {
            return markdown.replace(TEMPLATE_KEYWORD, NOT_AVAILABLE_MESG);
        } else {

            return markdown.replace(TEMPLATE_KEYWORD, chompTrailingNewlines(buildTable()));
        }
    }

    private String buildTable() {
        StringWriter sWtr = new StringWriter();
        PrintWriter pWtr = new PrintWriter(sWtr);

        pWtr.println("Catalog | Path");
        pWtr.println("--- | ---");
        pWtr.println("Previous | " + stats.getDiffInfo().getOldCatalogTsvBgz());
        pWtr.println("Current | " + stats.getDiffInfo().getNewCatalogTsvBgz());

        closeQuietly(pWtr);
        closeQuietly(sWtr);
        return sWtr.toString();
    }
}
