package edu.mayo.bior.buildcatalog;

import java.io.File;

import edu.mayo.bior.catalog.CatalogMetadataConstant;
import edu.mayo.bior.catalog.verification.VerifierExecutionException;
import edu.mayo.bior.catalog.verification.VerifierInputException;
import edu.mayo.bior.catalog.verification.CatalogVerifier;
import edu.mayo.bior.catalog.verification.CatalogVerifier.VAL_TYPE;

public class VerifyStep implements BuildCatalogStepInterface {

	public VerifyStep(BuildInfo buildInfo, StepLogger stepLogger) {
		mBuildInfo = buildInfo;
		mStepLogger = stepLogger;
	}

	public void execute() throws BuildCatalogStepInputException, BuildCatalogStepExecuteException {
		checkInput();

		mStepLogger.log("Starting verify catalog step :\n");
		mStepLogger.log("------------------------------------\n");
		
		int returnStatus=-1;
		try {
			CatalogVerifier catalogVerifier = new CatalogVerifier();
			returnStatus = catalogVerifier.verify(mCatalogFilePath, VAL_TYPE.STRICT, null);
		} catch (VerifierInputException inpute) {
			mStepLogger.log("Exception raised while acquiring catalog input. Exception: " + inpute.getMessage());
			throw new BuildCatalogStepExecuteException("Exception running catalog validation for catalog: " + mCatalogFilePath + "Exception raised: " + inpute.getMessage());
		} catch (VerifierExecutionException exece) {
			mStepLogger.log("Exception raised while verifying catalog. Exception: " + exece.getMessage());
			throw new BuildCatalogStepExecuteException("Exception running catalog validation for catalog: " + mCatalogFilePath + "Exception raised: " + exece.getMessage());
		}
		
		mStepLogger.log("Verify step completed. Exit Status: " + returnStatus + "\n");
		mStepLogger.log("------------------------------------\n");
	}

	private void checkInput() throws BuildCatalogStepInputException	 {
		String outputCatalogPath = null;
		outputCatalogPath = mBuildInfo.getTargetDirectory();
		mCatalogFilePath = outputCatalogPath + "/" + mBuildInfo.getCatalogPrefix() + CatalogMetadataConstant.CATALOG_FILE_SUFFIX;

		File catalogFile = new File(mCatalogFilePath);
		if (catalogFile != null) {
			if ( !catalogFile.canRead() || !catalogFile.isFile()) {
				throw new BuildCatalogStepInputException("VerifyStep.checkInput(): Catalog file doesn't exist or is not readable: " + mCatalogFilePath);
			}
		}
	}
	
	private BuildInfo mBuildInfo;
	private StepLogger mStepLogger;
	
	private String mCatalogFilePath = null;
}
