package edu.mayo.bior.catalog.verification;

import static junit.framework.Assert.assertNull;
import static org.junit.Assert.assertNotNull;

import java.io.File;
import java.io.StringWriter;

import org.junit.Before;
import org.junit.Test;

import edu.mayo.bior.catalog.CatalogDataSource;
import edu.mayo.pipes.util.BiorProperties;

/**
 * Test HumanReferenceInfo class
 */
public class HumanReferenceInfoTest
{
	
   @Before
   public void beforeEach() {
	   BiorProperties.setFile("src/test/resources/bior.properties.test");
   }

   
   @Test
   public void testHumanReferenceInfo37() throws Exception
   {
      CatalogDataSource dataSource37 = new CatalogDataSource(new File("src/test/resources/testData/grch37.datasource.properties"));
      MessageLogger messageLogger = new MessageLogger(new StringWriter());
      HumanReferenceInfo info = new HumanReferenceInfo(dataSource37.getHumanBuildAssembly(), messageLogger);
      assertNotNull(info.getChrSizeMap());
      assertNotNull(info.getExpectedChrOrderList());
      assertNotNull(info.getRefseqFileNm());
   }

   @Test
   public void testHumanReferenceInfo38() throws Exception
   {
      CatalogDataSource dataSource38 = new CatalogDataSource(new File("src/test/resources/testData/grch38.datasource.properties"));
      MessageLogger messageLogger = new MessageLogger(new StringWriter());
      HumanReferenceInfo info = new HumanReferenceInfo(dataSource38.getHumanBuildAssembly(), messageLogger);
      assertNotNull(info.getChrSizeMap());
      assertNotNull(info.getExpectedChrOrderList());
      assertNotNull(info.getRefseqFileNm());
   }

   @Test
   public void testNonHumanReferenceInfo() throws Exception
   {
      CatalogDataSource noBuildSource = new CatalogDataSource(new File("src/test/resources/testData/nobuild.datasource.properties"));
      MessageLogger messageLogger = new MessageLogger(new StringWriter());
      HumanReferenceInfo info = new HumanReferenceInfo(noBuildSource.getHumanBuildAssembly(), messageLogger);
      assertNull(info.getChrSizeMap());
      assertNull(info.getExpectedChrOrderList());
      assertNull(info.getRefseqFileNm());
   }

}
