package edu.mayo.bior.catalog.markdown.transformer.comparison;

import edu.mayo.bior.catalog.markdown.transformer.TransformException;
import org.junit.Test;

import java.io.IOException;

import static org.junit.Assert.assertEquals;

public class CatalogTop5ColumnUpdateImplTest {

    private static final char NEWLINE = '\n';

    @Test
    public void transform() throws IOException, TransformException {

        final int PREVIOUS_CATALOG_ROWS = 10;
        final int REMOVED_ROWS = 2;
        final int ADDED_ROWS = 7;
        final int VALUE_CHANGED_ROWS = 8;
        final int CURRENT_CATALOG_ROWS = PREVIOUS_CATALOG_ROWS - REMOVED_ROWS + ADDED_ROWS;

        CatalogDiffStatistics.ColumnStats columnA = new CatalogDiffStatistics().new ColumnStats();
        columnA.setName("COLUMN_A");
        columnA.setAdded(0);
        columnA.setRemoved(0);
        columnA.setValueChanged(5);
        columnA.setDatatypeChanged(0);
        columnA.setValueUnchanged(0);

        CatalogDiffStatistics.ColumnStats columnB = new CatalogDiffStatistics().new ColumnStats();
        columnB.setName("COLUMN_B");
        columnB.setAdded(0);
        columnB.setRemoved(0);
        columnB.setValueChanged(8);
        columnB.setDatatypeChanged(0);
        columnB.setValueUnchanged(0);

        CatalogDiffStatistics.ColumnStats columnC = new CatalogDiffStatistics().new ColumnStats();
        columnC.setName("COLUMN_C");
        columnC.setAdded(0);
        columnC.setRemoved(0);
        columnC.setValueChanged(6);
        columnC.setDatatypeChanged(0);
        columnC.setValueUnchanged(0);

        CatalogDiffStatistics.ColumnStats columnD = new CatalogDiffStatistics().new ColumnStats();
        columnD.setName("COLUMN_D");
        columnD.setAdded(0);
        columnD.setRemoved(0);
        columnD.setValueChanged(0);
        columnD.setDatatypeChanged(0);
        columnD.setValueUnchanged(8);

        CatalogDiffStatistics.ColumnStats columnE = new CatalogDiffStatistics().new ColumnStats();
        columnE.setName("COLUMN_E");
        columnE.setAdded(0);
        columnE.setRemoved(0);
        columnE.setValueChanged(7);
        columnE.setDatatypeChanged(0);
        columnE.setValueUnchanged(0);

        CatalogDiffStatistics.ColumnStats columnF = new CatalogDiffStatistics().new ColumnStats();
        columnF.setName("COLUMN_F");
        columnF.setAdded(0);
        columnF.setRemoved(0);
        columnF.setValueChanged(4);
        columnF.setDatatypeChanged(0);
        columnF.setValueUnchanged(0);

        CatalogDiffStatistics.SummaryStats summaryStats = new CatalogDiffStatistics().new SummaryStats();
        summaryStats.setCatalogOldEntries(PREVIOUS_CATALOG_ROWS);
        summaryStats.setCatalogNewEntries(CURRENT_CATALOG_ROWS);
        summaryStats.setCatalogEntriesAdded(ADDED_ROWS);
        summaryStats.setCatalogEntriesRemoved(REMOVED_ROWS);
        summaryStats.setCatalogEntriesChanged(ADDED_ROWS + REMOVED_ROWS + VALUE_CHANGED_ROWS);

        CatalogDiffStatistics stats = new CatalogDiffStatistics();
        CatalogDiffStatistics.ColumnStats[] columnStatsArr = {columnA, columnB, columnC, columnD, columnE, columnF};
        stats.setColumnStats(columnStatsArr);
        stats.setSummaryStats(summaryStats);

        CatalogTop5ColumnUpdateImpl transformer = new CatalogTop5ColumnUpdateImpl(stats);

        final String ORIGINAL_MARKDOWN =
                "BEGIN" + NEWLINE +
                CatalogTop5ColumnUpdateImpl.TEMPLATE_KEYWORD + NEWLINE +
                "END";

        final String EXPECTED_MARKDOWN =
                "BEGIN" + NEWLINE +
                "Rank | Updated Column | Update Type | # Updated Rows | % Updated Rows" + NEWLINE +
                "--- | --- | --- | --- | ---" + NEWLINE +
                "1 | COLUMN\\_B | Column Value Updated | 8 | 100.0%" + NEWLINE +
                "2 | COLUMN\\_E | Column Value Updated | 7 | 87.5%" + NEWLINE +
                "3 | COLUMN\\_C | Column Value Updated | 6 | 75.0%" + NEWLINE +
                "4 | COLUMN\\_A | Column Value Updated | 5 | 62.5%" + NEWLINE +
                "5 | COLUMN\\_F | Column Value Updated | 4 | 50.0%" + NEWLINE +
                "END";

        String actualMarkdown = transformer.transform(ORIGINAL_MARKDOWN);
        assertEquals(EXPECTED_MARKDOWN, actualMarkdown);
    }

    @Test
    public void transformWithOnlyOneColumn() throws IOException, TransformException {

        final int PREVIOUS_CATALOG_ROWS = 10;
        final int REMOVED_ROWS = 2;
        final int ADDED_ROWS = 7;
        final int VALUE_CHANGED_ROWS = 5;
//        final int VALUE_UNCHANGED_ROWS = 3;
        final int CURRENT_CATALOG_ROWS = PREVIOUS_CATALOG_ROWS - REMOVED_ROWS + ADDED_ROWS;

        CatalogDiffStatistics.ColumnStats columnA = new CatalogDiffStatistics().new ColumnStats();
        columnA.setName("COLUMN_A");
        columnA.setAdded(0);
        columnA.setRemoved(0);
        columnA.setValueChanged(VALUE_CHANGED_ROWS);
        columnA.setDatatypeChanged(0);
        columnA.setValueUnchanged(0);

        CatalogDiffStatistics.SummaryStats summaryStats = new CatalogDiffStatistics().new SummaryStats();
        summaryStats.setCatalogOldEntries(PREVIOUS_CATALOG_ROWS);
        summaryStats.setCatalogNewEntries(CURRENT_CATALOG_ROWS);
        summaryStats.setCatalogEntriesAdded(ADDED_ROWS);
        summaryStats.setCatalogEntriesRemoved(REMOVED_ROWS);
        summaryStats.setCatalogEntriesChanged(ADDED_ROWS + REMOVED_ROWS + VALUE_CHANGED_ROWS);

        CatalogDiffStatistics stats = new CatalogDiffStatistics();
        CatalogDiffStatistics.ColumnStats[] columnStatsArr = {columnA};
        stats.setColumnStats(columnStatsArr);
        stats.setSummaryStats(summaryStats);

        CatalogTop5ColumnUpdateImpl transformer = new CatalogTop5ColumnUpdateImpl(stats);

        final String ORIGINAL_MARKDOWN =
                "BEGIN" + NEWLINE +
                        CatalogTop5ColumnUpdateImpl.TEMPLATE_KEYWORD + NEWLINE +
                        "END";

        final String EXPECTED_MARKDOWN =
                "BEGIN" + NEWLINE +
                        "Rank | Updated Column | Update Type | # Updated Rows | % Updated Rows" + NEWLINE +
                        "--- | --- | --- | --- | ---" + NEWLINE +
                        "1 | COLUMN\\_A | Column Value Updated | 5 | 100.0%" + NEWLINE +
                        "2 | | | " + NEWLINE +
                        "3 | | | " + NEWLINE +
                        "4 | | | " + NEWLINE +
                        "5 | | | " + NEWLINE +
                        "END";

        String actualMarkdown = transformer.transform(ORIGINAL_MARKDOWN);
        assertEquals(EXPECTED_MARKDOWN, actualMarkdown);
    }

    @Test
    public void transformMissingCatalogDiffStats() throws IOException, TransformException {

        CatalogTop5ColumnUpdateImpl transformer = new CatalogTop5ColumnUpdateImpl(null);

        final String ORIGINAL_MARKDOWN =
                "BEGIN" + NEWLINE +
                        CatalogTop5ColumnUpdateImpl.TEMPLATE_KEYWORD + NEWLINE +
                        "END";

        final String EXPECTED_MARKDOWN =
                "BEGIN" + NEWLINE +
                        ComparisonStatsImpl.NOT_AVAILABLE_MESG + NEWLINE +
                        "END";

        String actualMarkdown = transformer.transform(ORIGINAL_MARKDOWN);
        assertEquals(EXPECTED_MARKDOWN, actualMarkdown);
    }
}
