package edu.mayo.bior.catalog.markdown.transformer.comparison;

import edu.mayo.bior.catalog.markdown.transformer.TransformException;
import org.junit.Test;

import java.io.IOException;

import static org.junit.Assert.assertEquals;

public class CatalogTableImplTest {

    private static final char NEWLINE = '\n';

    @Test
    public void transform() throws IOException, TransformException {

        CatalogDiffStatistics.DiffInfo diffInfo = new CatalogDiffStatistics().new DiffInfo();
        diffInfo.setOldCatalogTsvBgz("/path/to/old");
        diffInfo.setNewCatalogTsvBgz("/path/to/new");

        CatalogDiffStatistics stats = new CatalogDiffStatistics();
        stats.setDiffInfo(diffInfo);

        CatalogTableImpl transformer = new CatalogTableImpl(stats);

        final String ORIGINAL_MARKDOWN =
                "BEGIN" + NEWLINE +
                CatalogTableImpl.TEMPLATE_KEYWORD + NEWLINE +
                "END";

        final String EXPECTED_MARKDOWN =
                "BEGIN" + NEWLINE +
                "Catalog | Path" + NEWLINE +
                "--- | ---" + NEWLINE +
                "Previous | /path/to/old" + NEWLINE +
                "Current | /path/to/new" + NEWLINE +
                "END";

        String actualMarkdown = transformer.transform(ORIGINAL_MARKDOWN);
        assertEquals(EXPECTED_MARKDOWN, actualMarkdown);
    }

    @Test
    public void transformMissingCatalogDiffStats() throws IOException, TransformException {

        CatalogTableImpl transformer = new CatalogTableImpl(null);

        final String ORIGINAL_MARKDOWN =
                "BEGIN" + NEWLINE +
                CatalogTableImpl.TEMPLATE_KEYWORD + NEWLINE +
                "END";

        final String EXPECTED_MARKDOWN =
                "BEGIN" + NEWLINE +
                ComparisonStatsImpl.NOT_AVAILABLE_MESG + NEWLINE +
                "END";

        String actualMarkdown = transformer.transform(ORIGINAL_MARKDOWN);
        assertEquals(EXPECTED_MARKDOWN, actualMarkdown);
    }
}
