package edu.mayo.bior.catalog.markdown.transformer.comparison;

import edu.mayo.bior.catalog.markdown.transformer.TransformException;
import org.junit.Test;

import java.io.IOException;

import static org.junit.Assert.assertEquals;

public class CatalogContentChangesImplTest {

    private static final char NEWLINE = '\n';

    @Test
    public void transform() throws IOException, TransformException {

        CatalogDiffStatistics.ColumnStats column1 = new CatalogDiffStatistics().new ColumnStats();
        column1.setName("COLUMN1");
        column1.setAdded(1);
        column1.setValueChanged(2);
        column1.setRemoved(3);
        column1.setValueUnchanged(4);
        column1.setDatatypeChanged(5);

        CatalogDiffStatistics.ColumnStats column2 = new CatalogDiffStatistics().new ColumnStats();
        column2.setName("COLUMN2");
        column2.setAdded(6);
        column2.setValueChanged(7);
        column2.setRemoved(8);
        column2.setValueUnchanged(9);
        column2.setDatatypeChanged(10);

        CatalogDiffStatistics.SummaryStats summaryStats = new CatalogDiffStatistics().new SummaryStats();
        summaryStats.setCatalogColumnDataTypeChange(11);
        summaryStats.setCatalogColumnRemoved(22);
        summaryStats.setCatalogColumnAdded(33);
        summaryStats.setCatalogColumnValueChanged(44);
        summaryStats.setCatalogColumnValueUnchanged(55);
        summaryStats.setCatalogColumnComparisons(66);
        summaryStats.setCatalogColumnAllChanges(77);
        summaryStats.setCatalogOldEntries(88);
        summaryStats.setCatalogNewEntries(99);
        summaryStats.setCatalogEntriesChanged(111);

        CatalogDiffStatistics stats = new CatalogDiffStatistics();
        CatalogDiffStatistics.ColumnStats[] columnStatsArr = {column1, column2};
        stats.setColumnStats(columnStatsArr);
        stats.setSummaryStats(summaryStats);

        CatalogContentChangesImpl transformer = new CatalogContentChangesImpl(stats);

        final String ORIGINAL_MARKDOWN =
                "BEGIN" + NEWLINE +
                CatalogContentChangesImpl.TEMPLATE_KEYWORD + NEWLINE +
                "END";

        final String EXPECTED_MARKDOWN =
                "BEGIN" + NEWLINE +
                "ColumnName | Removed | Added | Changed | Datatype | Unchanged" + NEWLINE +
                "--- | --- | --- | --- | --- | ---" + NEWLINE +
                "COLUMN1 | 3 (20.000%) | 1 (6.667%) | 2 (13.333%) | 5 (33.333%) | 4 (26.667%)" + NEWLINE +
                "COLUMN2 | 8 (20.000%) | 6 (15.000%) | 7 (17.500%) | 10 (25.000%) | 9 (22.500%)" + NEWLINE +
                "TOTAL | 22 (13.333%) | 33 (20.000%) | 44 (26.667%) | 11 (6.667%) | 55 (33.333%)" + NEWLINE +
                "END";

        String actualMarkdown = transformer.transform(ORIGINAL_MARKDOWN);
        assertEquals(EXPECTED_MARKDOWN, actualMarkdown);
    }

    @Test
    public void transformMissingCatalogDiffStats() throws IOException, TransformException {

        CatalogContentChangesImpl transformer = new CatalogContentChangesImpl(null);

        final String ORIGINAL_MARKDOWN =
                "BEGIN" + NEWLINE +
                CatalogContentChangesImpl.TEMPLATE_KEYWORD + NEWLINE +
                "END";

        final String EXPECTED_MARKDOWN =
                "BEGIN" + NEWLINE +
                ComparisonStatsImpl.NOT_AVAILABLE_MESG + NEWLINE +
                "END";

        String actualMarkdown = transformer.transform(ORIGINAL_MARKDOWN);
        assertEquals(EXPECTED_MARKDOWN, actualMarkdown);
    }
}