package edu.mayo.bior.util;

import java.util.Comparator;

/** Filename comparator by numeric part.  For example, given these filenames:<br>
 *    you.23.txt  me.100.txt  me.4.txt  me.1.txt<br>
 *  It will sort these as:
 *    me.1.txt  me.4.txt  me.100.txt  you.23.txt
 * @author Michael Meiners (m054457)
 *
 */
@SuppressWarnings ("null")	// Compiler can't follow logic
public class FilenameComparatorByNumericPart  implements Comparator<String> {

	public int compare(String filename1, String filename2) {
		boolean is1NullOrEmpty = filename1 == null || filename1.length() == 0;
		boolean is2NullOrEmpty = filename2 == null || filename2.length() == 0;
		if( is1NullOrEmpty && is2NullOrEmpty )
			return 0;
		if( is1NullOrEmpty )
			return -1;
		if( is2NullOrEmpty )
			return 1;
		
		int start1 = 0;
		int start2 = 0;
		int end1   = filename1.length()-1;
		int end2   = filename2.length()-1;
		
		// Remove all same characters off the front
		//   my.123.txt   =>  123.txt
		//   my.92.txt    =>  92.txt
		while( start1 < filename1.length()  &&  start2 < filename2.length()  &&  filename1.charAt(start1) == filename2.charAt(start2) ) {
			start1++;
			start2++;
		}
		
		// Remove all same characters off the back
		//   123.txt  =>  123
		//   92.txt   =>  92
		while( start1 <= end1  &&  start2 <= end2  &&  filename1.charAt(end1) == filename2.charAt(end2) ) {
			end1--;
			end2--;
		}
		
		// Expand the strings out in both directions as long as we hit integers
		// Ex:  If we start with "my.003.txt", and were down to "3", then expand it to "003"
		while( start1 > 0  &&  Character.isDigit(filename1.charAt(start1-1)) )
			start1--;
		while( start2 > 0  &&  Character.isDigit(filename2.charAt(start2-1)) )
			start2--;
		while( end1 < (filename1.length()-1)  &&  Character.isDigit(filename1.charAt(end1+1)) )
			end1++;
		while( end2 < (filename2.length()-1)  &&  Character.isDigit(filename2.charAt(end2+1)) )
			end2++;

		
		// Compare the remaining parts of the strings.  
		// If both integers, then compare them based on the integer values, otherwise string comparisons
		String filename1Substr = filename1.substring(start1, end1+1);
		String filename2Substr = filename2.substring(start2, end2+1);
		
		if( isInt(filename1Substr)  &&  isInt(filename2Substr) )
			return new Integer(filename1Substr).compareTo(new Integer(filename2Substr));
		else
			return filename1Substr.compareTo(filename2Substr);
	}


	private boolean isInt(String str) {
		try {
			Integer.parseInt(str);
			return true;
		} catch(Exception e) {
			return false;
		}
	}

}
