package edu.mayo.bior.cli.cmd;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.transform.IdentityPipe;
import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.bior.util.ClasspathUtil;
import edu.mayo.cli.CommandLineApp;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.JSON.DrillPipe;
import edu.mayo.pipes.bioinformatics.BED2JSONPipe;
import edu.mayo.pipes.bioinformatics.GFF32JSONPipe;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;


public class GFF2JSONCommand implements CommandPlugin {

//    public void init(Properties props) throws Exception {
//        System.out.println("init!");
//        operation = props.getProperty("command.name");
//    }
//
//    public void execute(CommandLine line, Options opts) throws Exception {
//        System.out.println("Executing...");
//        Metadata metadata = new Metadata(operation);
//
//        Pipe<String,  History> preLogic  = new HistoryInPipe(metadata);
//        Pipe<History, History>  logic     = new GFF32JSONPipe();
//        Pipe<History, String>   postLogic = new HistoryOutPipe();
//
//        mPipeline.execute(preLogic, logic, postLogic);
//    }


//    private static final char OPTION_KEEP_JSON = 'k';
//    private static final char OPTION_PATH = 'p';
//    private static final char OPTION_DRILL_COLUMN = 'c';

    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private String operation;

    public void init(Properties props) throws Exception {
        operation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws Exception {

//        boolean keepJSON = false;
//        if (line.hasOption(OPTION_KEEP_JSON)) {
//            keepJSON = true;
//        }
//
//        List<String> paths = new ArrayList<String>();
//        if (line.hasOption(OPTION_PATH)) {
//            for (String value : line.getOptionValues(OPTION_PATH)) {
//                paths.add(value);
//            }
//        }
//
//        Integer col = -1;
//        if (line.hasOption(OPTION_DRILL_COLUMN)) {
//            col = new Integer(line.getOptionValue(OPTION_DRILL_COLUMN));
//        }
//
        String[] gffcols = new String[10];
        gffcols[0] = "seqid";
        gffcols[1] = "source";
        gffcols[2] = "type";
        gffcols[3] = "start";
        gffcols[4] = "end";
        gffcols[5] = "score";
        gffcols[6] = "strand";
        gffcols[7] = "phase";
        gffcols[8] = "attributes";
        gffcols[9] = "bior.gff";

        Pipe<String,  History>  preLogic  = new HistoryInPipe(gffcols);
        Pipe<History, History>  logic     = new GFF32JSONPipe();
        Pipe<History, String>   postLogic = new HistoryOutPipe();

        mPipeline.execute(preLogic, logic, postLogic);
    }

//    public static void main(String[] args){
//        CommandLineApp cli = new CommandLineApp();
//        String[] subArgs = new String[2];
//        subArgs[0] = "edu.mayo.bior.cli.cmd.GFF2JSONCommand";
//        subArgs[1] = "bior_gff3_to_tjson";
//        cli.main(subArgs);
//    }
}
