/**
 * bior_pipeline
 *
 * <p>@author Gregory Dougherty</p>
 * Copyright Mayo Clinic, 2014
 *
 */
package edu.mayo.bior.util;

import static org.junit.Assert.*;
import org.junit.Test;

/**
 * Test that {@linkplain TextCleaner} correctly deals with all edge cases
 *
 * <p>@author Gregory Dougherty</p>
 */
public class TextCleanerTest
{
	
	/**
	 * Test method for {@link edu.mayo.bior.util.TextCleaner#process (java.lang.String)}.
	 */
	@Test
	public void testProcessString ()
	{
		TextCleaner	cleaner = new TextCleaner ("[\"", "\"]");
		String[]	testStrs = {"[\"A\"]", "[\"Ac\"]", "[\"A", "A\"]", "A", "[AB\"]CD"};
		String[]	resultStrs = {"A", "Ac", "A", "A", "A", "[AB\"]CD"};
		int			which = 0;
		
		for (String testStr : testStrs)
		{
			String	result = cleaner.process (testStr);
			assertEquals ("Clean of " + testStr + " failed", resultStrs[which], result);
			++which;
		}
	}
	
	
	/**
	 * Test method for {@link edu.mayo.bior.util.TextCleaner#process (java.lang.String)}.
	 */
	@Test
	public void testProcessNumber ()
	{
		TextCleaner	cleaner = new TextCleaner ("[", "]");
		String[]	testStrs = {"[0.99857]", "[1]", "[0.995", "1234]", "123", "0.995"};
		String[]	resultStrs = {"0.99857", "1", "0.995", "1234", "123", "0.995"};
		int			which = 0;
		
		for (String testStr : testStrs)
		{
			String	result = cleaner.process (testStr);
			assertEquals ("Clean of " + testStr + " failed", resultStrs[which], result);
			++which;
		}
	}
	
	
	/**
	 * Test method for {@link edu.mayo.bior.util.TextCleaner#process (java.lang.String)}.
	 */
	@Test
	public void testProcessReplace ()
	{
		TextCleaner	cleaner = new TextCleaner ("[\"", "\",\"", ":", "\"]");
		String[]	testStrs = {"[\"A\"]", "[\"A\",\"C\"]", "[\"A\", \"A\"]", "[\"A\",\"D\",\"E\"]", 
		        	            "[\",\"]", "[\"A\",\"D\",\"]", "A\",\"C\"]", "[\"A\",\"C"};
		String[]	resultStrs = {"A", "A:C", "A\", \"A", "A:D:E", ",", "A:D\",", "A:C", "A:C"};
		int			which = 0;
		
		for (String testStr : testStrs)
		{
			String	result = cleaner.process (testStr);
			assertEquals ("Clean of " + testStr + " failed", resultStrs[which], result);
			++which;
		}
	}
	
}
