package edu.mayo.bior.cli.func;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import org.junit.Test;


public class ChunkCommandITCase  extends BaseFunctionalTest {

	
	private String input = 
			"##Header line 1\n" +
			"##Header line 2\n" +
			"#Header line 3 - column header\n" +
			"1\ta\n" +
			"2\tb\n" +
			"3\tc\n" +
			"4\td\n" +
			"5\te\n";

	
	@Test
	public void startOnly() throws IOException, InterruptedException {
	    CommandOutput out = executeScript("bior_chunk", input, "-s", "2", "-n", "--log");
        assertEquals(out.stderr, 0, out.exit);
        assertEquals("", out.stderr);
        
        String actual = out.stdout;
        String expected = "2\tb\n" + "3\tc\n" + "4\td\n" + "5\te\n";
        assertEquals(expected, actual);	
    }

	
	@Test
	public void startAndEndOnly() throws IOException, InterruptedException {
	    CommandOutput out = executeScript("bior_chunk", input, "-s", "2", "-e", "4", "-n" );
        assertEquals(out.stderr, 0, out.exit);
        assertEquals("", out.stderr);
        
        String actual = out.stdout;
        String expected = "2\tb\n" + "3\tc\n" + "4\td\n";
        assertEquals(expected, actual);	
    }

	@Test
	public void startAndEndSame() throws IOException, InterruptedException {
	    CommandOutput out = executeScript("bior_chunk", input, "-s", "2", "-e", "2", "-n" );
        assertEquals(out.stderr, 0, out.exit);
        assertEquals("", out.stderr);
        
        String actual = out.stdout;
        String expected = "2\tb\n";
        assertEquals(expected, actual);	
    }

	@Test
	public void endBeyondLastLine() throws IOException, InterruptedException {
	    CommandOutput out = executeScript("bior_chunk", input, "-s", "2", "-e", "10", "-n");
        assertEquals(out.stderr, 0, out.exit);
        assertEquals("", out.stderr);
        
        String actual = out.stdout;
        String expected = "2\tb\n" + "3\tc\n" + "4\td\n" + "5\te\n";
        assertEquals(expected, actual);	
    }

	@Test
	public void startAndEnd_withHeader() throws IOException, InterruptedException {
	    CommandOutput out = executeScript("bior_chunk", input, "-s", "2", "-e", "5");
        assertEquals(out.stderr, 0, out.exit);
        assertEquals("", out.stderr);
        
        String actual = out.stdout;
        String expected = "##Header line 1\n" +	"##Header line 2\n" +  "#Header line 3 - column header\n"  +  "2\tb\n" + "3\tc\n" + "4\td\n" + "5\te\n";
        assertEquals(expected, actual);	
    }

	@Test
	public void startBeforeEnd() throws IOException, InterruptedException {
	    CommandOutput out = executeScript("bior_chunk", input, "-s", "2", "-e", "1", "-n");
        assertEquals(out.stderr, 1, out.exit);
        assertEquals("", out.stdout);
        assertTrue("ErrorOutput: " + out.stderr, out.stderr.startsWith("ChunkPipe: Start line must be before (or equal to) end line"));
    }

	@Test
	public void startZero() throws IOException, InterruptedException {
	    CommandOutput out = executeScript("bior_chunk", input, "-s", "0");
        assertEquals(out.stderr, 1, out.exit);
        assertEquals("", out.stdout);
        assertTrue("ErrorOutput: " + out.stderr, out.stderr.startsWith("ChunkPipe: Start line must be >= 1"));
    }

	@Test
	public void endZero() throws IOException, InterruptedException {
	    CommandOutput out = executeScript("bior_chunk", input, "-s", "1", "-e", "0");
        assertEquals(out.stderr, 1, out.exit);
        assertEquals("", out.stdout);
        assertTrue("ErrorOutput: " + out.stderr, out.stderr.startsWith("ChunkPipe: End line must be >= 1 (or -1, or unspecified to read to end of lines)"));
    }
	
	
}
