package edu.mayo.bior.cli.cmd;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import org.junit.Test;

import edu.mayo.pipes.util.test.FileCompareUtils;
import edu.mayo.pipes.util.test.PipeTestUtils;

public class ConcatCommandTest {
	
	private final String DIR = "src/test/resources/Concat/";
	private final String TEMP_DIR = DIR + "Temp/";
	
	@Test
	public void concat7files() throws IOException {
		ConcatCommand concat = new ConcatCommand();
		String outFilePath = TEMP_DIR + "my.vcf.out.gz";
		List<String> vcfInList = Arrays.asList(
				DIR + "my.vcf.1",
				DIR + "my.vcf.2",
				DIR + "my.vcf.3",
				DIR + "my.vcf.4",
				DIR + "my.vcf.5",
				DIR + "my.vcf.6",
				DIR + "my.vcf.done"
				);
		concat.concatVcfs(vcfInList, outFilePath, true);
		compareFileContents(DIR + "expected.my.vcf", outFilePath);
		
	}

	//===========================================================================
	private void compareFileContents(String expectedFilePath, String actualFilePath) throws IOException {
		List<String> expected = FileCompareUtils.loadFile(expectedFilePath);
		List<String> actual   = FileCompareUtils.loadFile(actualFilePath);
		PipeTestUtils.assertListsEqual(expected, actual);
	}


}
