/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package edu.mayo.bior.cli;

import com.tinkerpop.pipes.util.Pipeline;

import edu.mayo.pipes.JSON.tabix.SameVariantPipe;
import edu.mayo.pipes.MergePipe;
import edu.mayo.pipes.PrintPipe;
import edu.mayo.pipes.UNIX.CatPipe;
import edu.mayo.pipes.UNIX.GrepPipe;
import edu.mayo.pipes.bioinformatics.VCF2VariantPipe;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.util.test.PipeTestUtils;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import static org.junit.Assert.*;

/**
 *
 * @author m102417
 */
public class SameVariantOnEspTest {
    
    public SameVariantOnEspTest() {
    }
    
    @BeforeClass
    public static void setUpClass() {
    }
    
    @AfterClass
    public static void tearDownClass() {
    }
    
    @Before
    public void setUp() {
    }
    
    @After
    public void tearDown() {
    }
    // TODO add test methods here.
    // The methods must be annotated with annotation @Test. For example:
    //
    @Test
    public void sameVariantTest() throws IOException {
        String greg = "src/test/resources/gregExample.vcf";
        Pipeline p = new Pipeline(
        		new CatPipe(),
                new GrepPipe("865628"),
                new HistoryInPipe (), 
                new VCF2VariantPipe (),
                new SameVariantPipe("src/test/resources/ESPFuncTest.tsv.bgz"),
                new MergePipe("\t")//, //new GrepPipe("865628")
                //new PrintPipe()
                );
        p.setStarts(Arrays.asList(greg));
        List<String> results = PipeTestUtils.getResults(p);
        
        assertEquals(1, results.size());
        
        String[] cols = results.get(0).split("\t");
        assertEquals(299, cols.length);
        
        String jsonExpectedPrefix = "{'CHROM':'1','POS':'865628','ID':'rs41285790','REF':'G','ALT':'A','QUAL':'.','FILTER':'PASS','INFO':{'DBSNP':['dbSNP_127'],'EA_AC':['44','8550'],'AA_AC':['1','4391'],'TAC':['45','12941'],'MAF':['0.512','0.0228','0.3465'],'GTS':['AA','AG','GG'],'EA_GTC':['0','44','4253'],'AA_GTC':['0','1','2195'],'GTC':['0','45','6448'],".replaceAll("'", "\"");
        String jsonActual = cols[298];
        assertTrue(jsonActual.startsWith(jsonExpectedPrefix));
    }
}
