package edu.mayo.bior.catalog;

import edu.mayo.bior.catalog.ChunkUtils;
import org.junit.Test;

import static org.junit.Assert.assertTrue;
import static org.junit.Assert.assertFalse;

public class ChunkUtilsTest
{
   @Test
   public void testInTargetChunk()
   {
      assertFalse(ChunkUtils.inTargetChunk(1, 2, 0));
      assertTrue(ChunkUtils.inTargetChunk(2, 2, 0));
      assertTrue(ChunkUtils.inTargetChunk(3, 2, 0));
      assertTrue(ChunkUtils.inTargetChunk(1000000, 2, 0));
      assertFalse(ChunkUtils.inTargetChunk(0, 1, 0));
      assertTrue(ChunkUtils.inTargetChunk(1, 1, 0));
      assertTrue(ChunkUtils.inTargetChunk(2, 1, 0));

      assertTrue(ChunkUtils.inTargetChunk(1, 1, 20));
      assertTrue(ChunkUtils.inTargetChunk(11, 2, 10));
      assertFalse(ChunkUtils.inTargetChunk(12, 2, 10));
   }

   @Test
   public void testBeyondTargetChunk()
   {
      assertFalse(ChunkUtils.beyondTargetChunk(2, 2, 0));
      assertFalse(ChunkUtils.beyondTargetChunk(1000000, 50, 0));
      assertFalse(ChunkUtils.beyondTargetChunk(10, 2, 10));
      assertFalse(ChunkUtils.beyondTargetChunk(11, 2, 10));
      assertTrue(ChunkUtils.beyondTargetChunk(12, 2, 10));
   }
}
