/**
 * bior_pipeline
 *
 * <p>@author Gregory Dougherty</p>
 * Copyright Mayo Clinic, 2014
 *
 */
package edu.mayo.bior.util;

/**
 * Class to add text before and / or after a non-blank value, so long as the value doesn't already 
 * possess the given prefix / suffix
 *
 * <p>@author Gregory Dougherty</p>
 */
public class TextWrapper extends FieldProcessorBase
{
	private String	prefix;
	private String	suffix;
	
	
	/**
	 * Create a TextWrapper that adds the given {@code prefix} and / or {@code suffix} text to any 
	 * non-blank, non-null values
	 * 
	 * @param prefix	Text to add to the beginning of the passed in non-blank string
	 * @param suffix	Text to add to the end of the passed in non-blank string
	 */
	public TextWrapper (String prefix, String suffix)
	{
		if ((prefix != null) && prefix.isEmpty ())
			this.prefix = null;
		else
			this.prefix = prefix;
		
		if ((suffix != null) && suffix.isEmpty ())
			this.suffix = null;
		else
			this.suffix = suffix;
	}
	
	
	/* (non-Javadoc)
	 * @see edu.mayo.bior.util.FieldProcessor#process(java.lang.String)
	 */
	public String process (String value)
	{
		if (super.isBlank (value))
			return gCurBlankValue;
		
		boolean	addEnd = (suffix != null) && !value.endsWith (suffix);
		
		if ((prefix != null) && !value.startsWith (prefix))
		{
			if (addEnd)
				return prefix + value + suffix;
			
			return prefix + value;
		}
		
		if (addEnd)
			return value + suffix;
		
		return value;
	}
	
}
