package edu.mayo.bior.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.CharSet;

import com.google.common.base.Charsets;
import com.google.common.io.Files;

/** NOTE: IS THIS CLASS REALLY NEEDED AS USER COULD JUST USE SED TO REPLACE STRINGS?
 *        WELL, MAYBE IF THE VALUES OCCUR IN A LIST LIKE 'MAF=0.01,nan,0.13'
 */

/** Replaces the values of specified VCF INFO keys
 *  
 *  Given an input file with format:
 *    #Key             ValueFrom    ValueTo     Comment
 *    MAF              0.00         (REMOVE)    Remove this value (and key) when it occurs
 *    MAF              nan          (NULL)      JSON should be null rather than removed - NOTE: VERIFY THAT THIS WORKS WITH bior_vcf_to_tjson!!!!!!
 *    InbreedingCoeff  nan          (REMOVE)
 *    InbreedingCoeff  -inf         -1e34       Set to the max negative value
 *  This 
 * @author Michael Meiners (m054457), Jan 31, 2017
 *
 */
public class ReplaceVcfInfoValues {

	Map<String,String> replacementMap = new HashMap<String,String>();
	
	public static void main(String[] args) {
		
		if( true )	
			throw new RuntimeException("NEED TO IMPLEMENT THIS CLASS.  All of the code below is from ReplaceLines.java");
		
		
		
		
		
		
		
		if( args.length != 2 ) {
			System.out.println("Replace a line with another in an input stream.");
			System.out.println("Warns if any lines are not used.");
			System.out.println("USAGE:  _bior_replace_line  --fromLines  <FILE_WITH_LINES_TO_REPLACE>  --toLines  <FILE_WITH_LINES_TO_ADD>");
			System.exit(1);
		}
		
		try {
			String fileLinesToReplace = args[0];
			String fileLinesToReplaceWith = args[1];
			new ReplaceVcfInfoValues(fileLinesToReplace, fileLinesToReplaceWith).replaceLines();
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	public ReplaceVcfInfoValues(String fileLinesToReplace, String fileLinesToReplaceWith) throws Exception {
		List<String> linesToReplace = Files.readLines(new File(fileLinesToReplace), Charsets.UTF_8);
		List<String> linesToReplaceWith = Files.readLines(new File(fileLinesToReplaceWith), Charsets.UTF_8);
		
		if( linesToReplace.size() != linesToReplaceWith.size() ) {
			throw new Exception("ReplaceLine: the two input files must have the same number of lines");
		}
		
		for(int i=0; i < linesToReplace.size(); i++) {
			replacementMap.put(linesToReplace.get(i), linesToReplaceWith.get(i));
		}
	}
	
	private void replaceLines() throws IOException {
		BufferedReader fin = new BufferedReader(new InputStreamReader(System.in));
		BufferedWriter fout = new BufferedWriter(new OutputStreamWriter(System.out));
		
		String line = null;
		while( (line = fin.readLine()) != null ) {
			String lineToReplaceWith = replacementMap.get(line);
			if( lineToReplaceWith != null ) {
				System.out.println(lineToReplaceWith);
			} else {
				System.out.println(line);
			}
		}
		
		if( fin != null ) {
			fin.close();
		}

		if( fout != null ) {
			fout.close();
		}
	}
}
