/**
 * bior_pipeline
 *
 * <p>@author Gregory Dougherty</p>
 * Copyright Mayo Clinic, 2014
 *
 */
package edu.mayo.bior.util;

import java.util.HashSet;
import java.util.Set;

/**
 * 
 *
 * <p>@author Gregory Dougherty</p>
 */
abstract public class FieldProcessorBase implements FieldProcessor
{
	protected static String			gCurBlankValue = kBlankValue;
	protected static Set<String>	gCurBlanks = null;
	
	
	/**
	 * Add a String to be recognized as a blank by all {@linkplain FieldProcessor}s, 
	 * in addition to all existing blanks
	 * 
	 * @param value	String to be recognized as blank.  Null will be ignored
	 */
	public static void addABlank (String value)
	{
		if (value == null)
			return;
		
		if ((gCurBlanks == null))
		{
			if (value.equals (kBlank))
				return;
			
			gCurBlanks = new HashSet<String> ();
			gCurBlanks.add (kBlank);
		}
		
		gCurBlanks.add (value);
	}
	
	
	/**
	 * Set a String to be recognized as the only non-null blank by all {@linkplain FieldProcessor}s, 
	 * deleting all existing blanks
	 * 
	 * @param value	String to be recognized as blank.  If null will keep anything but null from 
	 * being recognized as blank
	 */
	public static void setABlank (String value)
	{
		if (gCurBlanks == null)
			gCurBlanks = new HashSet<String> ();
		else
			gCurBlanks.clear ();
		
		if (value != null)
			gCurBlanks.add (value);
	}
	
	
	/**
	 * Set a String that all {@linkplain FieldProcessor}s will returned when find a blank, can be null
	 * 
	 * @param value	String to be returned when find a blank, can be null
	 */
	public static void setTheBlankValue (String value)
	{
		gCurBlankValue = value;
	}
	
	
	/**
	 * Get all the strings that all {@linkplain FieldProcessor}s recognize as blank, other than null
	 * 
	 * @return	Array of non-null strings
	 */
	public static String[] getAllBlanks ()
	{
		String[]	result;
		
		if (gCurBlanks != null)
		{
			int	numBlanks = gCurBlanks.size ();
			
			result = gCurBlanks.toArray (new String[numBlanks]);
		}
		else
		{
			result = new String[1];
			result[0] = kBlank;
		}
		
		return result;
	}
	
	
	/* (non-Javadoc)
	 * @see edu.mayo.bior.util.FieldProcessor#addBlank(java.lang.String)
	 */
	public void addBlank (String value)
	{
		addABlank (value);
	}
	
	
	/* (non-Javadoc)
	 * @see edu.mayo.bior.util.FieldProcessor#setBlank(java.lang.String)
	 */
	public void setBlank (String value)
	{
		setABlank (value);
	}
	
	
	/* (non-Javadoc)
	 * @see edu.mayo.bior.util.FieldProcessor#setBlankValue(java.lang.String)
	 */
	public void setBlankValue (String value)
	{
		setTheBlankValue (value);
	}
	
	
	/* (non-Javadoc)
	 * @see edu.mayo.bior.util.FieldProcessor#getBlanks()
	 */
	public String[] getBlanks ()
	{
		return getAllBlanks ();
	}
	
	
	/**
	 * Determine if a String is one of the strings specified as a blank
	 * 
	 * @param value	String to test, can be anything, including null
	 * @return	True if a blank, false if not
	 */
	protected boolean isBlank (String value)
	{
		if (value == null)
			return true;
		
		if (gCurBlanks != null)
			return gCurBlanks.contains (value);
		
		return kBlank.equals (value);
	}
	
}
