/**
 * bior_pipeline
 *
 * <p>@author Gregory Dougherty</p>
 * Copyright Mayo Clinic, 2014
 *
 */
package edu.mayo.bior.util;

import java.util.HashSet;
import java.util.Set;

/**
 * Class that looks for {@code kBlank}, and returns {@code kBlankValue} if found
 *
 * <p>@author Gregory Dougherty</p>
 */
public class DefaultProcessor extends FieldProcessorBase
{
	private Set<String>	blanks = null;
	
	
	/**
	 * Standard Constructor
	 */
	public DefaultProcessor ()
	{
		// Do Nothing
	}
	
	
	/**
	 * Add an additional blank to the set of blanks for this object
	 * 
	 * @param blank	New blank to add.  If null will be ignored
	 */
	public void addLocalBlank (String blank)
	{
		if (blank == null)
			return;
		
		if (blanks == null)
			blanks = new HashSet<String> ();
		
		blanks.add (blank);
	}
	
	
	/* (non-Javadoc)
	 * @see edu.mayo.bior.util.FieldProcessor#process(java.lang.String)
	 */
	public String process (String value)
	{
		if (super.isBlank (value))
			return gCurBlankValue;
		
		if ((blanks != null) && blanks.contains (value)) 
			return gCurBlankValue;
		
		return value;
	}
	
}
