package edu.mayo.bior.pipeline.VEP;

public class SiftPolyphenScore {
	public String siftTerm;
	public Double siftScore;
	public String polyphenTerm;
	public Double polyphenScore;
	// Tie-breaker
	public String feature;
	
	public SiftPolyphenScore(String siftTerm, Double siftScore, String polyphenTerm, Double polyphenScore, String feature) {
		this.siftTerm = siftTerm;
		this.siftScore = siftScore;
		this.polyphenTerm = polyphenTerm;
		this.polyphenScore = polyphenScore;
		this.feature = feature;
		
		// If either term is not given, then set to empty string
		if( this.siftTerm == null )
			this.siftTerm = "";
		if( this.polyphenTerm == null )
			this.polyphenTerm = "";
		
		// If sift score is null, then set to most benign (0.0 is most severe)
		if( this.siftScore == null )
			this.siftScore = 1.0;
		// If polyphen score is null, then set to most benign (opposite of SIFT - 1 is most severe)
		if( this.polyphenScore == null )
			this.polyphenScore = 0.0;
	}
}
