package edu.mayo.bior.cli.cmd;

import java.util.Properties;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

import com.tinkerpop.pipes.transform.IdentityPipe;

import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.ChunkPipe;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.string.TrimSpacesPipe;

public class ChunkCommand implements CommandPlugin
{
	private String mOperation;

	private static final char OPTION_START_LINE = 's';
	private static final char OPTION_END_LINE   = 'e';
	private static final char OPTION_NO_HEADER_FLAG = 'n';  // Do NOT include header


	
	public void init(Properties props) throws Exception	{
		mOperation = props.getProperty("command.name");
	}

	public void execute(CommandLine line, Options opts) throws Exception
	{
		long start = Long.parseLong(line.getOptionValue(OPTION_START_LINE));
		long end   = -1;
		if( line.hasOption(OPTION_END_LINE) )
			end   = Long.parseLong(line.getOptionValue(OPTION_END_LINE));
		boolean isIncludeHeader = ! line.hasOption(OPTION_NO_HEADER_FLAG);
		
		ChunkPipe chunkPipe = new ChunkPipe(start, end, isIncludeHeader);
		UnixStreamPipeline unixPipe = new UnixStreamPipeline();
		unixPipe.execute(
				new IdentityPipe(),
				chunkPipe,
				new IdentityPipe()
				);
	}	
}
