package edu.mayo.bior.catalog.markdown;

public class MarkdownUtils {

    /** Some characters, such as "_" will cause the markdown to render formatting.  Escape those characters with a backslash.
     *  See section "Backslash escapes" on: https://confluence.atlassian.com/bitbucketserver/markdown-syntax-guide-776639995.html */
    public static String escapeChrs(String markdown) {
        if( markdown == null  ||  markdown.length() == 0 ) {
            return "";
        } else {
            return markdown.replaceAll("\\\\", 	"\\\\\\\\")
                    .replaceAll("`", 	"\\\\`")
                    .replaceAll("\\*", 	"\\\\*")
                    .replaceAll("_", 	"\\\\_")
                    .replaceAll("\\{", 	"\\\\{")
                    .replaceAll("\\}", 	"\\\\}")
                    .replaceAll("\\[", 	"\\\\[")
                    .replaceAll("\\]", 	"\\\\]")
                    .replaceAll("\\(", 	"\\\\(")
                    .replaceAll("\\)", 	"\\\\)")
                    .replaceAll("#", 	"\\\\#")
                    .replaceAll(">", 	"\\\\>")
                    .replaceAll("\\+", 	"\\\\+")
                    .replaceAll("-", 	"\\\\-")
                    .replaceAll("\\.", 	"\\\\.")
                    .replaceAll("!", 	"\\\\!")
                    .replaceAll("\\|", 	"\\\\|")
                    ;
        }
    }

    /**
     * Removes 0 or more consecutive newline characters on the END of the given string.
     * @param s String to be scanned for trailing newline characters.
     * @return Original string with trailing newline characters deleted.
     */
    public static String chompTrailingNewlines(String s) {

        StringBuilder stringBuilder = new StringBuilder(s);

        for (int i = stringBuilder.length() - 1; i >= 0; i--) {
            if (stringBuilder.charAt(i) == '\n') {
                stringBuilder.deleteCharAt(i);
            } else {
                break;
            }
        }
        return stringBuilder.toString();
    }

    /**
     * Prepends a '+' character if the number is positive.
     * @param i A long to turn into a string.
     * @return A string version of the integer.
     */
    public static String positiveNumPrint(long i) {
        if (i > 0) {
            return "+" + i;
        } else {
            return String.valueOf(i);
        }
    }
}
