package edu.mayo.bior.catalog;

import java.io.File;

public class Catalog {

	public static String getCatalogPrefix(String catalogFilePath) {
		String catalogNamePrefix = null;
		File catalogFile = new File(catalogFilePath);
		String basename = catalogFile.getName();

		final String catalogSuffix = CatalogMetadataConstant.CATALOG_FILE_SUFFIX;
		if (basename == null || basename.length() <= 0) {
			return null;
		}
		if (!basename.endsWith(catalogSuffix))	{
			return null;
		}

		int indexOfCatalogSuffix = basename.indexOf(catalogSuffix);
		if (indexOfCatalogSuffix != -1 && (indexOfCatalogSuffix + catalogSuffix.length() == basename.length())) {
			catalogNamePrefix = basename.substring(0,basename.indexOf(catalogSuffix));
			if (catalogNamePrefix != null && catalogNamePrefix.length() > 0) {
				return catalogNamePrefix;
			}
		}
		
		return null;
	}
}
