package edu.mayo.bior.buildcatalog;

import java.util.HashSet;
import java.util.Set;

/**
 * Created by m026366 on 7/14/16.
 */
public enum BuildInfoKey
{
	
   // NOTE:  If you change the name of these variables, you should keep them in sync with bior_catalog_auto project's AutoBuild.BuildInfoKeysToReplace
   MAKE_JSON_SCRIPT_PATH(/*isRequired=*/true, /*isNonEmptyValueRequired=*/true),
   MAKE_JSON_ARGS(true, false),
   MAKE_JSON_OUTPUT_FILE_PATH(false, false),
   TARGET_DIR(false, false),
   TEMP_DIR(false, false),
   DATA_SOURCE(true, true),
   DATA_SOURCE_VERSION(true, true),
   DATA_SOURCE_BUILD(true, false),
   DATA_SOURCE_DESCRIPTION(false, false),
   DATA_SOURCE_RELEASE_DATE(false,false),
   DATA_SOURCE_DATASET(false,false),
   CATALOG_PREFIX(true, true),
   INDEXES(false, false),
   PREVIOUS_CATALOG_PATH(false, false),
   // True if bior_build_catalog should sort all the rows
   SORT_ROWS(false, false),
   // Path should be handled specially (prepended to the existing path)
   PATH(false, false),
   // RefData directory or file
   REFDATA_PATH(false, false),
   SHARED_CLUSTER_DIR(false, false),
   /** Is the output of make_json script already in the 4-column final format of the catalog and bgzipped?
    *  If true, then we can skip extracting the 3 tabix columns from the JSON plus skip bgzipping the output file */
   FINAL_FORMAT(false, false);


   private boolean required;
   private boolean nonEmptyValueRequired;

   BuildInfoKey(boolean required, boolean nonEmptyValueRequired)
   {
      this.required = required;
      this.nonEmptyValueRequired = nonEmptyValueRequired;
   }

   public boolean isRequired()
   {
      return required;
   }

   public boolean isNonEmptyValueRequired()
   {
      return nonEmptyValueRequired;
   }

   public static Set<BuildInfoKey> getRequiredKeys()
   {
      Set<BuildInfoKey> requiredKeys = new HashSet<BuildInfoKey>();
      for (BuildInfoKey key : BuildInfoKey.values())
      {
         if (key.isRequired())
         {
            requiredKeys.add(key);
         }
      }
      return requiredKeys;
   }

   public static Set<BuildInfoKey> getNonEmptyValueRequiredKeys()
   {
      Set<BuildInfoKey> requiredKeys = new HashSet<BuildInfoKey>();
      for (BuildInfoKey key : BuildInfoKey.values())
      {
         if (key.isNonEmptyValueRequired())
         {
            requiredKeys.add(key);
         }
      }
      return requiredKeys;
   }
}
