package edu.mayo.bior.buildcatalog;


import org.apache.commons.io.FileUtils;

import java.io.File;
import java.io.IOException;

public class BackupUtils
{
   protected static boolean isCurrentSameAsLastBackup(File currentFile) throws IOException
   {
      File lastBackupFile = getLastBackup(currentFile);
      String currentContents = FileUtils.readFileToString(currentFile);
      String lastBackupContents = FileUtils.readFileToString(lastBackupFile);
      return currentContents.equals(lastBackupContents);
   }

   /** Get the last backup file.  Could be null if none exist
    * @throws IOException */
   protected static File getLastBackup(File currentFile) throws IOException {
      File last = null;
      int i=1;
      while( getBackup(currentFile, i).exists() ) {
         last = getBackup(currentFile, i);
         i++;
      }
      return last;
   }


   protected static void removeLastBackup(File currentFile) throws IOException {
      File lastBackup = getLastBackup(currentFile);
      if( lastBackup != null  &&  lastBackup.exists() ) {
         lastBackup.delete();
      }
   }

   /** Create a backup of the current columns file
    *  (for example, copy "dbsnp142_GRCh37.columns.tsv"  to "dbsnp142_GRCh37.columns.tsv.01" or "dbsnp142_GRCh37.columns.tsv.02")
    * @param currentColumnsFile
    * @throws IOException
    */
   protected static void backupCurrentFile(File currentFile) throws IOException {
      File nextBackupFile = getNextBackup(currentFile);
      FileUtils.copyFile(currentFile, nextBackupFile);
   }

   protected static File getNextBackup(File currentFile) throws IOException {
      File nextBackup;
      int i=1;
      do {
         nextBackup = getBackup(currentFile, i);
         i++;
      } while( nextBackup.exists() );
      return nextBackup;
   }

   protected static File getBackup(File currentFile, int i) throws IOException {
      String extension = (i < 10 ? ".0" : ".") + Integer.toString(i);
      File buildDir = new File(currentFile.getParentFile(), BuildCatalog.BUILD_SUBDIR);
      return new File(buildDir, currentFile.getName() + extension);
   }

}
