echo "This checks a single line against the different catalogs that are included in bior_annotate"
echo "Feel free to change this vcf variable to test different values, then use the values from the catalogs to validate output"

vcf="#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\n\
5\t140725523\trs112486508\tC\tT\t99\t.\t."

echo -e $vcf

basedir=/research/bsi/data/catalogs/bior/v1


echo -e "\n\n\nVEP:"
echo -e "$vcf" | bior_vep | grep -v "##"


echo -e "\n\n\nSNPEffect:"
echo -e "$vcf" | bior_snpeff | grep -v "##"


echo -e "\n\n\ndbSNP (same-variant):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_same_variant -d $basedir/dbSNP/137/00-All_GRCh37.tsv.bgz | grep -v "##"

echo -e "\n\n\ndbSNP Clinvar (same-variant):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_same_variant -d $basedir/dbSNP/137/clinvar_20130226_GRCh37.tsv.bgz | grep -v "##"

echo -e "\n\n\nCosmic (same-variant):"
echo -e "$vcf" |  bior_vcf_to_tjson | bior_same_variant -d $basedir/cosmic/v63/CosmicCompleteExport_GRCh37.tsv.bgz | grep -v "##"

echo -e "\n\n\nUCSC Blacklist (overlap):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_overlap -d $basedir/ucsc/hg19/wgEncodeDacMapabilityConsensusExcludable_GRCh37.tsv.bgz | grep -v "##"

echo -e "\n\n\nUCSC Conservation (overlap):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_overlap -d $basedir/ucsc/hg19/phastConsElements46way_GRCh37.tsv.bgz | grep -v "##"

echo -e "\n\n\nUCSC Enhancer (overlap):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_overlap -d $basedir/ucsc/hg19/vistaEnhancers_GRCh37.tsv.bgz | grep -v "##"

echo -e "\n\n\nUCSC TFBS (overlap):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_overlap -d $basedir/ucsc/hg19/tfbsConsSites_GRCh37.tsv.bgz | grep -v "##"

echo -e "\n\n\nUCSC TSS (overlap):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_overlap -d $basedir/ucsc/hg19/switchDbTss_GRCh37.tsv.bgz | grep -v "##"

echo -e "\n\n\nUCSC Unique (overlap):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_overlap -d $basedir/ucsc/hg19/wgEncodeDukeMapabilityRegionsExcludable_GRCh37.tsv.bgz | grep -v "##"

echo -e "\n\n\nUCSC Repeat (overlap):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_overlap -d $basedir/ucsc/hg19/rmsk_GRCh37.tsv.bgz | grep -v "##"

echo -e "\n\n\nUCSC Regulation (overlap):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_overlap -d $basedir/ucsc/hg19/oreganno_GRCh37.tsv.bgz | grep -v "##"

echo -e "\n\n\nMirBase (overlap):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_overlap -d $basedir/mirbase/release19/hsa_GRCh37.p5.tsv.bgz | grep -v "##"

echo -e "\n\n\nBGI (same-variant):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_same_variant -d $basedir/BGI/hg19/LuCAMP_200exomeFinal.maf_GRCh37.tsv.bgz | grep -v "##"

echo -e "\n\n\nESP (same-variant):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_same_variant -d $basedir/ESP/build37/ESP6500SI_GRCh37.tsv.bgz | grep -v "##"

echo -e "\n\n\nHapmap (same-variant):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_same_variant -d $basedir/hapmap/2010-08_phaseII+III/allele_freqs_GRCh37.tsv.bgz | grep -v "##"

echo -e "\n\n\n1000 Genomes (same-variant):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_same_variant -d $basedir/1000_genomes/20110521/ALL.wgs.phase1_release_v3.20101123.snps_indels_sv.sites_GRCh37.tsv.bgz | grep -v "##"

echo -e "\n\n\nNCBIGene (overlap):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_overlap -d $basedir/NCBIGene/GRCh37_p10/genes.tsv.bgz | grep -v "##"

echo -e "\n\n\nHGNC (lookup from NCBIGene 'GeneID'):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_overlap -d $basedir/NCBIGene/GRCh37_p10/genes.tsv.bgz | bior_drill -p GeneID | bior_lookup -d $basedir/hgnc/2012_08_12/hgnc_GRCh37.tsv.bgz -p Entrez_Gene_ID | grep -v "##"

echo -e "\n\n\nOMIM (lookup from HGNC 'mapped_OMIM_ID'):"
echo -e "$vcf" | bior_vcf_to_tjson | bior_overlap -d $basedir/NCBIGene/GRCh37_p10/genes.tsv.bgz| bior_drill -p GeneID | bior_lookup -d $basedir/hgnc/2012_08_12/hgnc_GRCh37.tsv.bgz -p Entrez_Gene_ID | bior_drill -p mapped_OMIM_ID | bior_lookup -d $basedir/omim/2013_02_27/genemap_GRCh37.tsv.bgz -p MIM_Number | grep -v "##"


