package edu.mayo.bior.util;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.FileNotFoundException;

import org.junit.Test;

public class CatalogUtilsTest {

	@Test
	public void testDeprecatedCatalog() {
		assertTrue( CatalogUtils.isDeprecated("src/test/resources/_bior_catalog_list/Catalogs/dbSNP/142_GRCh37.p13/variants_nodups.v1/00-All.vcf.tsv.bgz"));
		assertFalse(CatalogUtils.isDeprecated("src/test/resources/_bior_catalog_list/Catalogs/dbSNP/142_GRCh37.p13/variants_nodups.v2/00-All.vcf.tsv.bgz"));
		assertFalse(CatalogUtils.isDeprecated("someNonexistentPath.bgz"));
	}
}
