package edu.mayo.bior.pipeline.createcatalog;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import org.apache.commons.io.FileUtils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TabixCmdTest {

	@Rule
	public TemporaryFolder mTempFolder = new TemporaryFolder();
	
	@Test
	/** Get the tabix cmd line preferred path.  Won't get it from $PATH or $BIOR_LITE_HOME */
	public void testTabixPreferredPath() throws FileNotFoundException {
		String tabixCmdPath = TabixCmd.getTabixPreferredPath();
		// Ex: 
		//	/Users/m054457/EclipseWorkspace/bior-toolkit/src/main/scripts/tabixMac
		//	/usr/bin/tabix
		//  /usr/local/biotools/bior_scripts/4.1.2/bior-toolkit-4.1.2/bin/tabix
		//  /data5/bsi/bictools/src/samtools/1.3.1/htslib-1.3.1/tabix
		assertTrue(tabixCmdPath.endsWith("bior_toolkit/src/main/scripts/tabixMac")
			   ||  tabixCmdPath.endsWith("bior_toolkit/src/main/scripts/tabixLinux")
			   ||  tabixCmdPath.endsWith("/tabix"));
	}
	
	@Test
	/** Create a tabix index on a catalog */
	public void createTabixIndex() throws IOException, InterruptedException {
		mTempFolder.create();
		File tempDir = mTempFolder.newFolder();
		System.out.println("Temp dir: " + tempDir);
		File ctgFile = new File(tempDir, "ctg.tsv.bgz");
		FileUtils.copyFile(new File("src/test/resources/testData/tabix/00-First1K_GRCh37.tsv.bgz"), ctgFile);
		TabixCmd.createTabixIndex(ctgFile.getCanonicalPath());
		
		// Verify tabix index created
		File tabixFile = new File(tempDir, "ctg.tsv.bgz.tbi");
		assertTrue(tabixFile.exists());
	}
}
