package edu.mayo.bior.catalog.stats;

import org.junit.Test;

import static junit.framework.Assert.assertEquals;
import static junit.framework.Assert.assertFalse;
import static junit.framework.Assert.assertTrue;

/**
 * Simple test class for this Java bean.
 */
public class CatalogStatsTest
{
   private CatalogStats stats = new CatalogStats();

   @Test
   public void testBasic()
   {
      assertEquals(0, stats.getTotalDataLineCount());
      stats.setTotalDataLineCount(100);
      assertEquals(100, stats.getTotalDataLineCount());
      assertFalse(stats.getStoppedReadingAfterChunk());
      stats.setStoppedReadingAfterChunk(true);
      assertTrue(stats.getStoppedReadingAfterChunk());
      assertEquals(0, stats.getNumLinesSampled());
      stats.incrementNumLinesSampled();
      assertEquals(1, stats.getNumLinesSampled());
   }
}
