/**
 * bior_pipeline
 *
 * <p>@author Gregory Dougherty</p>
 * Copyright Mayo Clinic, 2014
 *
 */
package edu.mayo.bior.util;

/**
 * Parse a String, getting an int.  If that int gives a String from theLookup, will return it.  If 
 * String doesn't parse to an int, or the int + offset is negative or >= theLookup.length (), 
 * returns theLookup[0]
 *
 * <p>@author Gregory Dougherty</p>
 */
public class LookupProcessor extends FieldProcessorBase
{
	private String[]	lookupTable;
	private int			offset;
	private int			max;
	private String		defaultValue;
	
	
	/**
	 * Standard Constructor
	 * 
	 * @param lookupTable	Table of String values for given IDs. 0 == lookupTable[0], etc
	 */
	public LookupProcessor (String[] lookupTable)
	{
		this (lookupTable, 0);
	}
	
	
	/**
	 * Constructor to use when first value to look for isn't 0
	 * 
	 * @param lookupTable	Table of String values for given IDs. offset == lookupTable[0], etc
	 * @param offset		Value the defines where the range of the enumerations starts
	 */
	public LookupProcessor (String[] lookupTable, int offset)
	{
		this (lookupTable, offset, ((lookupTable == null) || (lookupTable.length == 0) ? null : lookupTable[0]));
	}

	
	/**
	 * Constructor to use when have a default value that isn't the first value
	 * 
	 * @param lookupTable	Table of String values for given IDs. offset == lookupTable[0], etc
	 * @param offset		Value the defines where the range of the enumerations starts
	 * @param defaultValue	Value to use when don't get a match
	 */
	public LookupProcessor (String[] lookupTable, int offset, String defaultValue)
	{
		this.lookupTable = lookupTable;
		this.offset = offset;
		this.defaultValue = defaultValue;
		
		if (lookupTable == null)
			max = 0;
		else
			max = lookupTable.length;
	}


	/* (non-Javadoc)
	 * @see edu.mayo.bior.util.FieldProcessor#process(java.lang.String)
	 */
	public String process (String value)
	{
		if (super.isBlank (value))
			return gCurBlankValue;
		
		int	result = 0;
		
		try
		{
			result = Integer.parseInt (value) - offset;
		}
		catch (NumberFormatException oops)
		{
			// Do nothing
		}
		
		if ((result < 0) || (result >= max))
			return defaultValue;
		
		return lookupTable[result];
	}
	
}
