/**
 * bior_pipeline
 *
 * <p>@author Gregory Dougherty</p>
 * Copyright Mayo Clinic, 2014
 *
 */
package edu.mayo.bior.util;

/**
 * Class containing all the information known about a catalog
 *
 * <p>@author Gregory Dougherty</p>
 */
public class CatalogInfo
{
	private String		name;
	private String		humanName;
	private String		build;
	private String		source;
	private String		description;
	private String		version;
	private String		path;
	private boolean		mustOverlap;
	private String[]	machineNames;
	private String[]	humanNames;
	
	
	/**
	 * Standard Constructor
	 * 
	 * @param name			Short unique name of the catalog
	 * @param humanName		Human aimed non-unique name
	 * @param build			GRCh build the data is targeted for
	 * @param source		Information about where the data in the catalog came from
	 * @param description	Description of what's in the catalog
	 * @param version		Version of the data
	 * @param path			Path to catalog file
	 * @param mustOverlap	If true, must use Overlap with this catalog, if false can use SameVariant
	 * @param machineNames	Array of unique & "pipe friendly" names for each field of catalog
	 * @param humanNames	Array of unique but more human readable names for each field of catalog
	 */
	public CatalogInfo (String name, String humanName, String build, String source, String description, String version, String path, 
						boolean mustOverlap, String[] machineNames, String[] humanNames)
	{
		this.name = name;
		this.humanName = humanName;
		this.build = build;
		this.source = source;
		this.description = description;
		this.version = version;
		this.path = path;
		this.mustOverlap = mustOverlap;
		this.machineNames = machineNames;
		this.humanNames = humanNames;
	}
	
	
	/**
	 * @return the name
	 */
	public final String getName ()
	{
		return name;
	}
	
	
	/**
	 * @return the humanName
	 */
	public final String getHumanName ()
	{
		return humanName;
	}
	
	
	/**
	 * @return the description
	 */
	public final String getDescription ()
	{
		return description;
	}
	
	
	/**
	 * @return the build
	 */
	public final String getBuild ()
	{
		return build;
	}
	
	
	/**
	 * @return the source
	 */
	public final String getSource ()
	{
		return source;
	}
	
	
	/**
	 * @return the version
	 */
	public final String getVersion ()
	{
		return version;
	}
	
	
	/**
	 * @return the path
	 */
	public final String getPath ()
	{
		return path;
	}
	
	
	/**
	 * @return the mustOverlap
	 */
	public final boolean isMustOverlap ()
	{
		return mustOverlap;
	}
	
	
	/**
	 * @return the machineNames
	 */
	public final String[] getMachineNames ()
	{
		return machineNames;
	}
	
	
	/**
	 * @return the humanNames
	 */
	public final String[] getHumanNames ()
	{
		return humanNames;
	}
	
}
