package edu.mayo.bior.pipeline.Treat.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.jayway.jsonpath.JsonPath;

import edu.mayo.bior.pipeline.Treat.JsonColumn;

public class VEPFormatter implements Formatter
{
	private boolean isJsonPathsInitialized = false;
	
	// JSON paths		
	// order of paths is important as this is the order
	// they will be applied in the format() method
	private List<JsonPath> mCompiledJsonPaths = null;
	
	private void initCompiledJsonPaths( ) {
		mCompiledJsonPaths = new ArrayList<JsonPath>();
		for(int i=0; i < paths.size(); i++) {
			mCompiledJsonPaths.add(JsonPath.compile(paths.get(i)));
		}
		isJsonPathsInitialized = true;
	}
	
	public JsonColumn getJSONColumn() {
		return JsonColumn.VEP;
	}

	private List<String> paths = Arrays.asList(
			"Allele",
			"Gene",
			"Feature",
			"Feature_type",
			"Consequence",
			"cDNA_position",
			"CDS_position",
			"Protein_position",
			"Amino_acids",
			"Codons",
			"HGNC",
			"SIFT_TERM",
			"SIFT_Score",
			"PolyPhen_TERM",
			"PolyPhen_Score"
			);
	

	public List<String> getHeaders() {
		return Arrays.asList( 
				"VEP.Allele",
				"VEP.Gene",
				"VEP.Feature",
				"VEP.Feature_type",
				"VEP.Consequence",
				"VEP.cDNA_position",
				"VEP.CDS_position",
				"VEP.Protein_position",
				"VEP.Amino_acids",
				"VEP.Codons",
				"VEP.HGNC",
				"SIFT.TERM",
				"SIFT.Score",
				"PolyPhen.TERM",
				"PolyPhen.Score"
				);
	}
	
	public List<String> format(String json) {
		if( ! isJsonPathsInitialized ) {
			initCompiledJsonPaths();
		}
		
		List<String> values = new ArrayList<String>();
		for (JsonPath path: mCompiledJsonPaths)	{
			// execute drill
			values.add( FormatUtils.drill(path, json) );
		}
		return values;
	}
	
	public List<String> getJsonDrillPaths() {
		return paths;
	}
}
