package edu.mayo.bior.cli.cmd;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.transform.IdentityPipe;

import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.MergePipe;
import edu.mayo.pipes.String2HistoryPipe;
import edu.mayo.pipes.JSON.DrillPipe;
import edu.mayo.pipes.JSON.modify.ModifyJsonPipe;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import edu.mayo.pipes.util.metadata.Metadata.CmdType;

public class ModifyTjsonCommand implements CommandPlugin {

	private static final char OPTION_CONFIG_FILE = 'f';	
    private static final char OPTION_JSON_COLUMN = 'c';

	private UnixStreamPipeline mPipeline = new UnixStreamPipeline();

	private String operation;
	
	
	public void init(Properties props) throws Exception {
		operation = props.getProperty("command.name");
	}

	public void execute(CommandLine line, Options opts) throws Exception {

		int jsonCol = getDrillColumn(line);
		File configFile = getConfigFile(line);
		
		Pipe<String,  History>  preLogic  = new StringToHistoryPipe();
		Pipe<History, History>      logic = new ModifyJsonPipe(jsonCol, configFile);
		Pipe<History, String>   postLogic = new HistoryToStringPipe();
		
		mPipeline.execute(preLogic, logic, postLogic);
	}

	private Integer getDrillColumn(CommandLine line) {
		Integer col = -1;
		if (line.hasOption(OPTION_JSON_COLUMN)) {
			col = new Integer(line.getOptionValue(OPTION_JSON_COLUMN));
		}
		return col;
	}

	private File getConfigFile(CommandLine line) {
		File configFile = null;
		if (line.hasOption(OPTION_CONFIG_FILE)) {
			configFile = new File(line.getOptionValue(OPTION_CONFIG_FILE));
		}
		return configFile;
	}
	
	
	//==============================================================
	class StringToHistoryPipe extends AbstractPipe<String, History> {
		@Override
		protected History processNextStart() throws NoSuchElementException {	
			String line = this.starts.next();
			return new History(line.split("\t"));
		}
	}

	//==============================================================
	class HistoryToStringPipe extends AbstractPipe<History, String> {
		@Override
		protected String processNextStart() throws NoSuchElementException {	
			History line = this.starts.next();
			return line.getMergedData("\t");
		}
	}

}
