package edu.mayo.bior.catalog.stats;

import java.util.*;

public class CatalogStats {

    /**
     * Column names.
     */
    private List<String> columnNames = new ArrayList<String>();

    /**
     * Column level stats indexed by column name.
     */
    private Map<String, CatalogColumnStats> columnStats = new HashMap<String, CatalogColumnStats>();

    /** Total number of lines in the catalog.  */
    private long totalDataLineCount;
    
    /** Number of lines sampled.  Ex: if the user chose to only sample 1 in 100 lines instead of every line */
    private long numLinesSampled;

    private boolean stoppedReadingAfterChunk = false;

    public Collection<String> getColumns() {
        return this.columnNames;
    }

    public long getTotalDataLineCount() {
        return this.totalDataLineCount;
    }

    public void setTotalDataLineCount(long totalDataLineCount) {
        this.totalDataLineCount = totalDataLineCount;
    }

    public boolean getStoppedReadingAfterChunk()
    {
        return this.stoppedReadingAfterChunk;
    }

    public void setStoppedReadingAfterChunk(boolean stoppedReadingAfterChunk)
    {
       this.stoppedReadingAfterChunk = stoppedReadingAfterChunk;
    }
    
    public void incrementTotalDataLineCount() {
    	this.totalDataLineCount++;
    }

    public long getNumLinesSampled() {
        return this.numLinesSampled;
    }

    public void setNumLinesSampled(long numLinesSampled) {
        this.numLinesSampled = numLinesSampled;
    }
    
    public void incrementNumLinesSampled() {
    	this.numLinesSampled++;
    }

    public CatalogColumnStats getColumnStats(String columnName) {
        return columnStats.get(columnName);
    }

    public void setColumns(List<String> columnNames) {
        this.columnNames = columnNames;
    }


    public void setColumnStats(String columnName, CatalogColumnStats stats) {
        this.columnStats.put(columnName, stats);
    }
}
