package edu.mayo.bior.catalog.stats;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class CatalogColumnStats {

	private String columnName;
	
    /**
     * Records the number of entries that had this specific column.
     */
    private long numEntries;

    /**
     * Records the total number of characters for this specific column for the entire catalog.
     */
    private long numCharacters;

    private AsciiCharacterStats totalAsciiStats;

    private AsciiCharacterStats lineAsciiStats;

    /**
     * Sampling of values for the specific column.  (value (string) ==> ValueSampling)
     */
    private HashMap<String,ValueSampling> valueSamplings = new LinkedHashMap<String,ValueSampling>();
    
    
    
    
    /** Get the column name that these values/stats are for */
    public String getColumnName() {
    	return this.columnName;
    }
    
    /** Set the column name that these values/stats are for */
    public void setColumnName(String colName) {
    	this.columnName = colName;
    }
    
    
    /** Total number of characters encountered in the values for the column/key across all sampled lines.  Duplicates also count. */
    public long getNumCharacters() {
        return this.numCharacters;
    }

    /** Total number of characters encountered in the values for the column/key across all sampled lines.  Duplicates also count. */
    public void setNumCharacters(Long numCharacters) {
        this.numCharacters = numCharacters;
    }

	public void incrementNumCharacters() {
		this.numCharacters++;
	}

    /** Total number of times the column/key occurred across all sampled lines */
    public long getNumEntries() {
        return this.numEntries;
    }

    /** Total number of times the column/key occurred across all sampled lines */
    public void setNumEntries(long numEntries) {
        this.numEntries = numEntries;
    }
    
    public void incrementNumEntries() {
    	this.numEntries++;
    }


    /** The total number of occurrences of a particular character across all sampled lines */
    public AsciiCharacterStats getTotalAsciiStats() {
    	return this.totalAsciiStats;
    }

    /** The total number of occurrences of a particular character across all sampled lines */
    public void setTotalAsciiStats(AsciiCharacterStats totalAsciiStats) {
        this.totalAsciiStats = totalAsciiStats;
    }

    
    /** The number of lines a particular character occurred on (NOT the number of occurrences of the character) */
    public AsciiCharacterStats getLineAsciiStats() {
    	return this.lineAsciiStats;
    }

    /** The number of lines a particular character occurred on (NOT the number of occurrences of the character) */
    public void setLineAsciiStats(AsciiCharacterStats lineAsciiStats) {
        this.lineAsciiStats = lineAsciiStats;
    }
    
    /** List of values encountered across all samples lines (up to the maximum limit) */
    public Collection<ValueSampling> getValueSamplings() {
        return this.valueSamplings.values();
    }
    
     public long getNumUniqueValues() {
    	return this.valueSamplings.size();
    }
    
    public ValueSampling getValueSampling(String value) {
    	return this.valueSamplings.get(value);
    }
    
    public void incrementValueCount(String value) {
    	this.valueSamplings.get(value).incrementFrequency();
    }
    
    public void addValueSampling(ValueSampling valSampling) {
    	this.valueSamplings.put(valSampling.getValue(), valSampling);
    }

    /** List of values encountered across all samples lines (up to the maximum limit) */
    public void setValueSamplings(Collection<ValueSampling> valueSamplings) {
        this.valueSamplings.clear();
        for(ValueSampling valSampleToAdd : valueSamplings) {
        	this.valueSamplings.put(valSampleToAdd.getValue(), valSampleToAdd);
        }
    }
}
