package edu.mayo.bior.catalog.markdown.transformer.comparison;

/**
 * Simple POJO containing catalog diff statistics.
 */
public class CatalogDiffStatistics {
    private DiffInfo diffInfo;
    private ColumnStats[] columnStats;
    private SummaryStats summaryStats;

    public ColumnStats[] getColumnStats() {
        return columnStats;
    }

    public void setColumnStats(ColumnStats[] columnStats) {
        this.columnStats = columnStats;
    }

    public SummaryStats getSummaryStats() {
        return summaryStats;
    }

    public void setSummaryStats(SummaryStats summaryStats) {
        this.summaryStats = summaryStats;
    }

    public DiffInfo getDiffInfo() { return diffInfo; }

    public void setDiffInfo(DiffInfo diffInfo) { this.diffInfo = diffInfo; }

    public class DiffInfo {
        private String oldCatalogTsvBgz;
        private String newCatalogTsvBgz;

        public String getOldCatalogTsvBgz() {
            return oldCatalogTsvBgz;
        }

        public void setOldCatalogTsvBgz(String oldCatalogTsvBgz) {
            this.oldCatalogTsvBgz = oldCatalogTsvBgz;
        }

        public String getNewCatalogTsvBgz() {
            return newCatalogTsvBgz;
        }

        public void setNewCatalogTsvBgz(String newCatalogTsvBgz) {
            this.newCatalogTsvBgz = newCatalogTsvBgz;
        }
    }

    public class SummaryStats {
        private long catalogColumnDataTypeChange;
        private long catalogColumnRemoved;
        private long catalogColumnAdded;
        private long catalogColumnValueChanged;
        private long catalogColumnValueUnchanged;
        private long catalogColumnComparisons;
        private long catalogColumnAllChanges;
        private long catalogOldEntries;
        private long catalogNewEntries;
        private long catalogEntriesAdded;
        private long catalogEntriesRemoved;
        private long catalogEntriesChanged;

        public long getCatalogColumnComparisons() {
            return catalogColumnComparisons;
        }

        public void setCatalogColumnComparisons(long catalogColumnComparisons) {
            this.catalogColumnComparisons = catalogColumnComparisons;
        }

        public long getCatalogColumnAllChanges() {
            return catalogColumnAllChanges;
        }

        public void setCatalogColumnAllChanges(long catalogColumnAllChanges) {
            this.catalogColumnAllChanges = catalogColumnAllChanges;
        }

        public long getCatalogOldEntries() {
            return catalogOldEntries;
        }

        public void setCatalogOldEntries(long catalogOldEntries) {
            this.catalogOldEntries = catalogOldEntries;
        }

        public long getCatalogNewEntries() {
            return catalogNewEntries;
        }

        public void setCatalogNewEntries(long catalogNewEntries) {
            this.catalogNewEntries = catalogNewEntries;
        }

        public long getCatalogEntriesChanged() {
            return catalogEntriesChanged;
        }

        public void setCatalogEntriesChanged(long catalogEntriesChanged) {
            this.catalogEntriesChanged = catalogEntriesChanged;
        }

        public long getCatalogColumnDataTypeChange() {
            return catalogColumnDataTypeChange;
        }

        public void setCatalogColumnDataTypeChange(long catalogColumnDataTypeChange) {
            this.catalogColumnDataTypeChange = catalogColumnDataTypeChange;
        }

        public long getCatalogColumnRemoved() {
            return catalogColumnRemoved;
        }

        public void setCatalogColumnRemoved(long catalogColumnRemoved) {
            this.catalogColumnRemoved = catalogColumnRemoved;
        }

        public long getCatalogColumnAdded() {
            return catalogColumnAdded;
        }

        public void setCatalogColumnAdded(long catalogColumnAdded) {
            this.catalogColumnAdded = catalogColumnAdded;
        }

        public long getCatalogColumnValueChanged() {
            return catalogColumnValueChanged;
        }

        public void setCatalogColumnValueChanged(long catalogColumnValueChanged) {
            this.catalogColumnValueChanged = catalogColumnValueChanged;
        }

        public long getCatalogColumnValueUnchanged() {
            return catalogColumnValueUnchanged;
        }

        public void setCatalogColumnValueUnchanged(long catalogColumnValueUnchanged) {
            this.catalogColumnValueUnchanged = catalogColumnValueUnchanged;
        }

        public long getCatalogEntriesAdded() {
            return catalogEntriesAdded;
        }

        public void setCatalogEntriesAdded(long catalogEntriesAdded) {
            this.catalogEntriesAdded = catalogEntriesAdded;
        }

        public long getCatalogEntriesRemoved() {
            return catalogEntriesRemoved;
        }

        public void setCatalogEntriesRemoved(long catalogEntriesRemoved) {
            this.catalogEntriesRemoved = catalogEntriesRemoved;
        }
    }

    public class ColumnStats {
        private String name;
        private long added;
        private long valueChanged;
        private long removed;
        private long valueUnchanged;
        private long datatypeChanged;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public long getAdded() {
            return added;
        }

        public void setAdded(long added) {
            this.added = added;
        }

        public long getValueChanged() {
            return valueChanged;
        }

        public void setValueChanged(long valueChanged) {
            this.valueChanged = valueChanged;
        }

        public long getRemoved() {
            return removed;
        }

        public void setRemoved(long removed) {
            this.removed = removed;
        }

        public long getValueUnchanged() {
            return valueUnchanged;
        }

        public void setValueUnchanged(long valueUnchanged) {
            this.valueUnchanged = valueUnchanged;
        }

        public long getDatatypeChanged() {
            return datatypeChanged;
        }

        public void setDatatypeChanged(long datatypeChanged) {
            this.datatypeChanged = datatypeChanged;
        }
    }
}
