package edu.mayo.bior.catalog;

public class ChunkUtils
{
   /**
    * Is lineNumber in region demarcated by startLine and numLines
    * @param lineNumber current line number in file
    * @param startLine  first line of region
    * @param numLines   number of lines in region. Can be 0
    * @return true if lineNunber in region. If numLines is 0, lineNumber >= startLine returns true. Otherwise, do the
    *         calculation. inTargetChunk(11, 2, 10) -> true. inTargetChunk(12, 2, 10) -> false.
    */
   public static boolean inTargetChunk(long lineNumber, long startLine, long numLines) {
      if (lineNumber < startLine) {
         return false;
      }

      if (beyondTargetChunk(lineNumber, startLine, numLines)) {
         return false;
      }

      return true;
   }

   /**
    * Is lineNumber beyond (after) region demarcated by startLine and numLines
    * @param lineNumber current line number in file
    * @param startLine  first line of region
    * @param numLines   number of lines in region. Can be 0
    * @return false if numLines == 0. Otherwise, do the calculation. beyondTargetChunk(1000000, 1, 0) -> false.
    *         beyondTargetChunk(11, 2, 10) -> false. beyondTargetChunk(12, 2, 10) -> true.
    */
   public static boolean beyondTargetChunk(long lineNumber, long startLine, long numLines) {
      if (numLines == 0) {
         return false;
      }
      return lineNumber > (startLine + numLines - 1);
   }
}
